/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.config;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.tools.EntityTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.dimensions.description.MobDescriptor;
import net.minecraftforge.common.config.Configuration;

public class MobConfiguration {
    public static final String CATEGORY_MOBS = "mobs";
    public static final Map<String, MobDescriptor> mobClasses = new HashMap<String, MobDescriptor>();
    public static MobDescriptor defaultDescriptor;

    public static void init(Configuration cfg) {
        int chance = cfg.get(CATEGORY_MOBS, "default.chance", 6).getInt();
        int mingroup = cfg.get(CATEGORY_MOBS, "default.mingroup", 1).getInt();
        int maxgroup = cfg.get(CATEGORY_MOBS, "default.maxgroup", 3).getInt();
        int maxentity = cfg.get(CATEGORY_MOBS, "default.maxentity", 10).getInt();
        defaultDescriptor = new MobDescriptor(null, chance, mingroup, maxgroup, maxentity);
        MobConfiguration.initMobItem(cfg, "Zombie", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, "Skeleton", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, "Enderman", 20, 2, 4, 20);
        MobConfiguration.initMobItem(cfg, "Blaze", 20, 2, 4, 20);
        MobConfiguration.initMobItem(cfg, "Creeper", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, "CaveSpider", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, "Ghast", 20, 2, 4, 20);
        MobConfiguration.initMobItem(cfg, "VillagerGolem", 20, 1, 2, 6);
        MobConfiguration.initMobItem(cfg, "LavaSlime", 50, 2, 4, 30);
        MobConfiguration.initMobItem(cfg, "PigZombie", 20, 2, 4, 10);
        MobConfiguration.initMobItem(cfg, "Slime", 50, 2, 4, 30);
        MobConfiguration.initMobItem(cfg, "SnowMan", 50, 2, 4, 30);
        MobConfiguration.initMobItem(cfg, "Spider", 100, 8, 8, 60);
        MobConfiguration.initMobItem(cfg, "Witch", 10, 1, 1, 20);
        MobConfiguration.initMobItem(cfg, "Bat", 10, 8, 8, 20);
        MobConfiguration.initMobItem(cfg, "Endermite", 6, 2, 4, 10);
        MobConfiguration.initMobItem(cfg, "Silverfish", 6, 2, 4, 10);
        MobConfiguration.initMobItem(cfg, "Rabbit", 10, 3, 4, 20);
        MobConfiguration.initMobItem(cfg, "Chicken", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, "Cow", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, "EntityHorse", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, "MushroomCow", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, "Ozelot", 5, 2, 3, 20);
        MobConfiguration.initMobItem(cfg, "Pig", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, "Sheep", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, "Squid", 10, 3, 4, 40);
        MobConfiguration.initMobItem(cfg, "Wolf", 10, 3, 4, 20);
        MobConfiguration.initMobItem(cfg, "Villager", 10, 3, 4, 20);
        MobConfiguration.initMobItem(cfg, "WitherBoss", 5, 1, 2, 5);
        MobConfiguration.initMobItem(cfg, "Guardian", 8, 1, 3, 7);
        MobConfiguration.initMobItem(cfg, "EnderDragon", 4, 1, 2, 4);
    }

    private static void initMobItem(Configuration cfg, String name, int chance, int mingroup, int maxgroup, int maxentity) {
        String id = EntityTools.fixEntityId((String)name);
        Class entityClass = EntityTools.findClassById((String)id);
        if (entityClass == null) {
            Logging.logError((String)("Cannot find mob with id '" + id + "'!"));
            return;
        }
        if (cfg != null) {
            chance = cfg.get(CATEGORY_MOBS, id + ".chance", chance).getInt();
            mingroup = cfg.get(CATEGORY_MOBS, id + ".mingroup", mingroup).getInt();
            maxgroup = cfg.get(CATEGORY_MOBS, id + ".maxgroup", maxgroup).getInt();
            maxentity = cfg.get(CATEGORY_MOBS, id + ".maxentity", maxentity).getInt();
        }
        mobClasses.put(id, new MobDescriptor(entityClass, chance, mingroup, maxgroup, maxentity));
    }
}

