/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.mapgen;

import java.util.Random;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class MapGenScatteredOrbs {
    private final GenericChunkGenerator provider;
    private final int r;

    public MapGenScatteredOrbs(GenericChunkGenerator provider) {
        this.provider = provider;
        this.r = 3;
    }

    public void generate(World world, int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState[] blocks = this.provider.dimensionInformation.getScatteredSphereBlocks();
        for (int cx = -this.r; cx <= this.r; ++cx) {
            for (int cz = -this.r; cz <= this.r; ++cz) {
                Random random = new Random((world.func_72905_C() + (long)(chunkX + cx)) * 113L + (long)((chunkZ + cz) * 31) + 77L);
                random.nextFloat();
                if (!(random.nextFloat() < 0.05f)) continue;
                int x = cx * 16 + random.nextInt(16);
                int y = 40 + random.nextInt(40);
                int z = cz * 16 + random.nextInt(16);
                int radius = random.nextInt(30) + 20;
                IBlockState block = Blocks.field_150348_b.func_176223_P();
                if (blocks.length > 1) {
                    block = blocks[random.nextInt(blocks.length)];
                } else if (blocks.length == 1) {
                    block = blocks[0];
                }
                this.fillSphere(primer, x, y, z, radius, block, random);
            }
        }
    }

    private void fillSphere(ChunkPrimer primer, int centerx, int centery, int centerz, int radius, IBlockState block, Random random) {
        for (int x = 0; x < 16; ++x) {
            double dxdx = (x - centerx) * (x - centerx);
            for (int z = 0; z < 16; ++z) {
                double dzdz = (z - centerz) * (z - centerz);
                int index = (x * 16 + z) * 256;
                for (int y = centery - radius; y <= centery + radius; ++y) {
                    double dydy = (y - centery) * (y - centery);
                    double dist = Math.sqrt(dxdx + dydy + dzdz);
                    if (!(dist < (double)radius)) continue;
                    double f = 1.0 - dist / (double)radius;
                    if (!(random.nextDouble() < f * f)) continue;
                    BaseTerrainGenerator.setBlockState(primer, index + y, block);
                }
            }
        }
    }
}

