/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ConfigSection {
    private final Common common;
    private final ConfigSection parent;
    private final String name;
    private final String lang;
    private ConfigCategory category;

    public ConfigSection(Common common, ConfigSection parent, String name, String lang) {
        this.common = common;
        this.parent = parent;
        this.name = name;
        this.lang = lang;
        common.getSections().add(this);
    }

    public ConfigSection(Common common, String name, String lang) {
        this(common, null, name, lang);
    }

    public ConfigCategory getCategory() {
        if (this.category != null) {
            return this.category;
        }
        this.category = this.parent != null ? this.common.getConfig().getCategory(this.parent.getCategory().getQualifiedName() + "." + this.name.toLowerCase()) : this.common.getConfig().getCategory(this.name.toLowerCase());
        this.category.setLanguageKey(this.common.getLangPrefix() + this.lang);
        return this.category;
    }

    public String getQualifiedName() {
        return this.getCategory().getQualifiedName();
    }

    public static class Common {
        private final List<ConfigSection> sections;
        private final Configuration config;
        private final String langPrefix;

        public Common(Configuration config, String langPrefix) {
            this.config = config;
            this.langPrefix = langPrefix;
            this.sections = new ArrayList<ConfigSection>();
        }

        public Common(Configuration config) {
            this(config, "");
        }

        public List<ConfigSection> getSections() {
            return this.sections;
        }

        public Configuration getConfig() {
            return this.config;
        }

        public String getLangPrefix() {
            return this.langPrefix;
        }
    }
}

