/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.BlockMeta;
import mcjty.lib.varia.Counter;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.blocks.builder.PacketChamberInfoReady;
import mcjty.rftools.blocks.builder.SpaceChamberRepository;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetChamberInfo
implements IMessage {
    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }

    public static class Handler
    implements IMessageHandler<PacketGetChamberInfo, IMessage> {
        public IMessage onMessage(PacketGetChamberInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(ctx));
            return null;
        }

        private void handle(MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack cardItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (ItemStackTools.isEmpty((ItemStack)cardItem) || cardItem.func_77978_p() == null) {
                return;
            }
            int channel = cardItem.func_77978_p().func_74762_e("channel");
            if (channel == -1) {
                return;
            }
            SpaceChamberRepository repository = SpaceChamberRepository.getChannels(player.func_130014_f_());
            SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
            if (chamberChannel == null) {
                return;
            }
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (world == null) {
                return;
            }
            Counter blocks = new Counter();
            Counter costs = new Counter();
            HashMap<BlockMeta, ItemStack> stacks = new HashMap<BlockMeta, ItemStack>();
            BlockPos minCorner = chamberChannel.getMinCorner();
            BlockPos maxCorner = chamberChannel.getMaxCorner();
            this.findBlocks((World)world, (Counter<BlockMeta>)blocks, (Counter<BlockMeta>)costs, stacks, minCorner, maxCorner);
            Counter entitiesWithCount = new Counter();
            Counter entitiesWithCost = new Counter();
            HashMap<String, Entity> firstEntity = new HashMap<String, Entity>();
            this.findEntities((World)world, minCorner, maxCorner, (Counter<String>)entitiesWithCount, (Counter<String>)entitiesWithCost, firstEntity);
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketChamberInfoReady((Map<BlockMeta, Integer>)blocks, (Map<BlockMeta, Integer>)costs, stacks, (Map<String, Integer>)entitiesWithCount, (Map<String, Integer>)entitiesWithCost, firstEntity), ctx.getServerHandler().field_147369_b);
        }

        private void findEntities(World world, BlockPos minCorner, BlockPos maxCorner, Counter<String> entitiesWithCount, Counter<String> entitiesWithCost, Map<String, Entity> firstEntity) {
            List entities = world.func_72839_b(null, new AxisAlignedBB((double)minCorner.func_177958_n(), (double)minCorner.func_177956_o(), (double)minCorner.func_177952_p(), (double)(maxCorner.func_177958_n() + 1), (double)(maxCorner.func_177956_o() + 1), (double)(maxCorner.func_177952_p() + 1)));
            for (Object o : entities) {
                EntityItem entityItem;
                Entity entity = (Entity)o;
                String canonicalName = entity.getClass().getCanonicalName();
                if (entity instanceof EntityItem && ItemStackTools.isValid((ItemStack)(entityItem = (EntityItem)entity).func_92059_d())) {
                    String displayName = entityItem.func_92059_d().func_82833_r();
                    canonicalName = canonicalName + " (" + displayName + ")";
                }
                entitiesWithCount.increment((Object)canonicalName);
                if (!firstEntity.containsKey(canonicalName)) {
                    firstEntity.put(canonicalName, entity);
                }
                if (entity instanceof EntityPlayer) {
                    entitiesWithCost.increment((Object)canonicalName, BuilderConfiguration.builderRfPerPlayer);
                    continue;
                }
                entitiesWithCost.increment((Object)canonicalName, BuilderConfiguration.builderRfPerEntity);
            }
        }

        private void findBlocks(World world, Counter<BlockMeta> blocks, Counter<BlockMeta> costs, Map<BlockMeta, ItemStack> stacks, BlockPos minCorner, BlockPos maxCorner) {
            for (int x = minCorner.func_177958_n(); x <= maxCorner.func_177958_n(); ++x) {
                for (int y = minCorner.func_177956_o(); y <= maxCorner.func_177956_o(); ++y) {
                    for (int z = minCorner.func_177952_p(); z <= maxCorner.func_177952_p(); ++z) {
                        TileEntity te;
                        BuilderSetup.BlockInformation info;
                        ItemStack item;
                        Block block;
                        BlockPos p = new BlockPos(x, y, z);
                        IBlockState state = world.func_180495_p(p);
                        if (BuilderTileEntity.isEmpty(state, block = state.func_177230_c())) continue;
                        int meta = block.func_176201_c(state);
                        BlockMeta bm = new BlockMeta(block, meta);
                        blocks.increment((Object)bm);
                        if (!stacks.containsKey(bm) && ItemStackTools.isValid((ItemStack)(item = block.func_185473_a(world, p, state)))) {
                            stacks.put(bm, item);
                        }
                        if ((info = BuilderTileEntity.getBlockInformation(world, p, block, te = world.func_175625_s(p))).getBlockLevel() == 2) {
                            costs.put((Object)bm, (Object)-1);
                            continue;
                        }
                        costs.increment((Object)bm, (int)((double)BuilderConfiguration.builderRfPerOperation * info.getCostFactor()));
                    }
                }
            }
        }
    }
}

