/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.ores;

import java.util.List;
import java.util.Random;
import mcjty.lib.compat.CompatBlock;
import mcjty.rftools.Achievements;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.ores.DimensionalShardItemBlock;
import mcjty.rftools.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DimensionalShardBlock
extends CompatBlock {
    public static final PropertyEnum<OreType> ORETYPE = PropertyEnum.func_177709_a((String)"oretype", OreType.class);
    private Random rand = new Random();

    public DimensionalShardBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149663_c("rftools.dimensional_shard_ore");
        this.setRegistryName("dimensional_shard_ore");
        this.func_149715_a(0.5f);
        this.func_149647_a(RFTools.tabRfTools);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new DimensionalShardItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "oretype=overworld"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "oretype=nether"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "oretype=end"));
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                world.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), this.rand.nextGaussian() / 3.0, this.rand.nextGaussian() / 3.0, this.rand.nextGaussian() / 3.0, new int[0]);
            }
        }
    }

    protected void clGetSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        super.clGetSubBlocks(itemIn, tab, subItems);
        subItems.add(new ItemStack((Block)this, 1, 0));
        subItems.add(new ItemStack((Block)this, 1, 1));
        subItems.add(new ItemStack((Block)this, 1, 2));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.dimensionalShardItem;
    }

    public int func_149745_a(Random random) {
        return 2 + random.nextInt(3);
    }

    public int func_149679_a(int bonus, Random random) {
        int j = random.nextInt(bonus + 2) - 1;
        if (j < 0) {
            j = 0;
        }
        return this.func_149745_a(random) * (j + 1);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return this.rand.nextInt(4) + 3;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (player != null) {
            Achievements.trigger(player, Achievements.specialOres);
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((OreType)((Object)state.func_177229_b(ORETYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ORETYPE, (Comparable)((Object)OreType.values()[meta]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORETYPE});
    }

    public static enum OreType implements IStringSerializable
    {
        ORE_OVERWORLD("overworld"),
        ORE_NETHER("nether"),
        ORE_END("end");

        private final String name;

        private OreType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

