/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketServerCommand;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.IScreenModuleUpdater;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.api.screens.data.IModuleDataBoolean;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import mcjty.rftools.api.screens.data.IModuleDataInteger;
import mcjty.rftools.api.screens.data.IModuleDataString;
import mcjty.rftools.blocks.screens.ScreenContainer;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.screens.data.ModuleDataBoolean;
import mcjty.rftools.blocks.screens.data.ModuleDataInteger;
import mcjty.rftools.blocks.screens.data.ModuleDataString;
import mcjty.rftools.blocks.screens.modules.ScreenModuleHelper;
import mcjty.rftools.blocks.screens.modulesclient.TextClientScreenModule;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScreenTileEntity
extends GenericTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_CLICK = "click";
    public static final String CMD_HOVER = "hover";
    public static final String CMD_SETBRIGHT = "setBright";
    public static final String CMD_SETTRUETYPE = "setTruetype";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ScreenContainer.factory, 11);
    public static Map<GlobalCoordinate, Map<Integer, IModuleData>> screenData = new HashMap<GlobalCoordinate, Map<Integer, IModuleData>>();
    private List<IClientScreenModule> clientScreenModules = null;
    private boolean needsServerData = false;
    private boolean showHelp = true;
    private boolean powerOn = false;
    private boolean connected = false;
    private int size = 0;
    private boolean transparent = false;
    private int color = 0;
    private boolean bright = false;
    private int trueTypeMode = 0;
    private int hoveringModule = -1;
    private int hoveringX = -1;
    private int hoveringY = -1;
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_LARGE = 1;
    public static final int SIZE_HUGE = 2;
    private List<IScreenModule> screenModules = null;
    private List<ActivatedModule> clickedModules = new ArrayList<ActivatedModule>();
    private int totalRfPerTick = 0;
    public long lastTime = 0L;
    private static List<IClientScreenModule> helpingScreenModules = null;
    private IScreenDataHelper screenDataHelper = new IScreenDataHelper(){

        @Override
        public IModuleDataInteger createInteger(int i) {
            return new ModuleDataInteger(i);
        }

        @Override
        public IModuleDataBoolean createBoolean(boolean b) {
            return new ModuleDataBoolean(b);
        }

        @Override
        public IModuleDataString createString(String b) {
            return new ModuleDataString(b);
        }

        @Override
        public IModuleDataContents createContents(long contents, long maxContents, long lastPerTick) {
            return new ScreenModuleHelper.ModuleDataContents(contents, maxContents, lastPerTick);
        }
    };

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        return new AxisAlignedBB((double)(xCoord - 1), (double)(yCoord - this.size - 1), (double)(zCoord - 1), (double)(xCoord + this.size + 1), (double)(yCoord + 1), (double)(zCoord + this.size + 1));
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    private void checkStateClient() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        ArrayList<ActivatedModule> newClickedModules = new ArrayList<ActivatedModule>();
        for (ActivatedModule cm : this.clickedModules) {
            cm.ticks--;
            if (cm.ticks > 0) {
                newClickedModules.add(cm);
                continue;
            }
            List<IClientScreenModule> modules = this.getClientScreenModules();
            if (cm.module >= modules.size()) continue;
            modules.get(cm.module).mouseClick(this.func_145831_w(), cm.x, cm.y, false);
        }
        this.clickedModules = newClickedModules;
    }

    private void checkStateServer() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        ArrayList<ActivatedModule> newClickedModules = new ArrayList<ActivatedModule>();
        for (ActivatedModule cm : this.clickedModules) {
            NBTTagCompound newCompound;
            cm.ticks--;
            if (cm.ticks > 0) {
                newClickedModules.add(cm);
                continue;
            }
            List<IScreenModule> modules = this.getScreenModules();
            if (cm.module >= modules.size()) continue;
            ItemStack itemStack = this.inventoryHelper.getStackInSlot(cm.module);
            IScreenModule module = modules.get(cm.module);
            module.mouseClick(this.func_145831_w(), cm.x, cm.y, false, null);
            if (!(module instanceof IScreenModuleUpdater) || (newCompound = ((IScreenModuleUpdater)((Object)module)).update(itemStack.func_77978_p(), this.func_145831_w(), null)) == null) continue;
            itemStack.func_77982_d(newCompound);
            this.markDirtyClient();
        }
        this.clickedModules = newClickedModules;
    }

    public int[] func_180463_a(EnumFacing side) {
        return ScreenContainer.factory.getAccessibleSlots();
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return ScreenContainer.factory.isOutputSlot(index);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return ScreenContainer.factory.isInputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        this.resetModules();
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    private void resetModules() {
        this.clientScreenModules = null;
        this.screenModules = null;
        this.clickedModules.clear();
        this.showHelp = true;
    }

    private boolean isActivated(int index) {
        for (ActivatedModule module : this.clickedModules) {
            if (module.module != index) continue;
            return true;
        }
        return false;
    }

    public void focusModuleClient(double hitX, double hitY, double hitZ, EnumFacing side) {
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side);
        if (result == null) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommand(this.func_174877_v(), CMD_HOVER, new Argument[]{new Argument("x", -1), new Argument("y", -1), new Argument("module", -1)}));
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommand(this.func_174877_v(), CMD_HOVER, new Argument[]{new Argument("x", result.getX()), new Argument("y", result.getY() - result.getCurrenty()), new Argument("module", result.getModuleIndex())}));
    }

    public void hitScreenClient(double hitX, double hitY, double hitZ, EnumFacing side) {
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side);
        if (result == null) {
            return;
        }
        List<IClientScreenModule> modules = this.getClientScreenModules();
        int module = result.getModuleIndex();
        if (this.isActivated(module)) {
            return;
        }
        modules.get(module).mouseClick(this.func_145831_w(), result.getX(), result.getY() - result.getCurrenty(), true);
        this.clickedModules.add(new ActivatedModule(module, 3, result.getX(), result.getY()));
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommand(this.func_174877_v(), CMD_CLICK, new Argument[]{new Argument("x", result.getX()), new Argument("y", result.getY() - result.getCurrenty()), new Argument("module", module)}));
    }

    public ModuleRaytraceResult getHitModule(double hitX, double hitY, double hitZ, EnumFacing side) {
        float factor = (float)this.size + 1.0f;
        float dx = 0.0f;
        float dy = (float)((-hitY + 1.0) / (double)factor);
        switch (side) {
            case NORTH: {
                dx = (float)((1.0 - hitX) / (double)factor);
                break;
            }
            case SOUTH: {
                dx = (float)(hitX / (double)factor);
                break;
            }
            case WEST: {
                dx = (float)(hitZ / (double)factor);
                break;
            }
            case EAST: {
                dx = (float)((1.0 - hitZ) / (double)factor);
                break;
            }
            default: {
                return null;
            }
        }
        int x = (int)(dx * 128.0f);
        int y = (int)(dy * 128.0f);
        int currenty = 7;
        int moduleIndex = 0;
        List<IClientScreenModule> clientScreenModules = this.getClientScreenModules();
        for (IClientScreenModule module : clientScreenModules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (currenty <= y && y < currenty + height) break;
                currenty += height;
            }
            ++moduleIndex;
        }
        if (moduleIndex >= clientScreenModules.size()) {
            return null;
        }
        ModuleRaytraceResult result = new ModuleRaytraceResult(moduleIndex, x, y, currenty);
        return result;
    }

    private void hitScreenServer(EntityPlayer player, int x, int y, int module) {
        List<IScreenModule> screenModules = this.getScreenModules();
        IScreenModule screenModule = screenModules.get(module);
        if (screenModule != null) {
            NBTTagCompound newCompound;
            ItemStack itemStack = this.inventoryHelper.getStackInSlot(module);
            screenModule.mouseClick(this.func_145831_w(), x, y, true, player);
            if (screenModule instanceof IScreenModuleUpdater && (newCompound = ((IScreenModuleUpdater)((Object)screenModule)).update(itemStack.func_77978_p(), this.func_145831_w(), player)) != null) {
                itemStack.func_77982_d(newCompound);
                this.markDirtyClient();
            }
            this.clickedModules.add(new ActivatedModule(module, 5, x, y));
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        this.resetModules();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean isUsable(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOn = tagCompound.func_74767_n("powerOn");
        this.connected = tagCompound.func_74767_n("connected");
        this.totalRfPerTick = tagCompound.func_74762_e("rfPerTick");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.resetModules();
        this.size = tagCompound.func_74764_b("large") ? (tagCompound.func_74767_n("large") ? 1 : 0) : tagCompound.func_74762_e("size");
        this.transparent = tagCompound.func_74767_n("transparent");
        this.color = tagCompound.func_74762_e("color");
        this.bright = tagCompound.func_74767_n("bright");
        this.trueTypeMode = tagCompound.func_74762_e("truetype");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("powerOn", this.powerOn);
        tagCompound.func_74757_a("connected", this.connected);
        tagCompound.func_74768_a("rfPerTick", this.totalRfPerTick);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("size", this.size);
        tagCompound.func_74757_a("transparent", this.transparent);
        tagCompound.func_74768_a("color", this.color);
        tagCompound.func_74757_a("bright", this.bright);
        tagCompound.func_74768_a("truetype", this.trueTypeMode);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.markDirtyClient();
    }

    public void setSize(int size) {
        this.size = size;
        this.markDirtyClient();
    }

    public boolean isBright() {
        return this.bright;
    }

    public void setBright(boolean bright) {
        this.bright = bright;
        this.markDirtyClient();
    }

    public int getTrueTypeMode() {
        return this.trueTypeMode;
    }

    public void setTrueTypeMode(int trueTypeMode) {
        this.trueTypeMode = trueTypeMode;
        this.markDirtyClient();
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.markDirtyClient();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setPower(boolean power) {
        if (this.powerOn == power) {
            return;
        }
        this.powerOn = power;
        this.markDirtyClient();
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isRenderable() {
        if (this.powerOn) {
            return true;
        }
        if (this.isShowHelp()) {
            return true;
        }
        return this.isCreative();
    }

    private boolean isCreative() {
        return this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() == ScreenSetup.creativeScreenBlock;
    }

    public void setConnected(boolean c) {
        if (this.connected == c) {
            return;
        }
        this.connected = c;
        this.markDirtyClient();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void updateModuleData(int slot, NBTTagCompound tagCompound) {
        ItemStack stack = this.inventoryHelper.getStackInSlot(slot);
        stack.func_77982_d(tagCompound);
        this.screenModules = null;
        this.clientScreenModules = null;
        this.func_70296_d();
    }

    public static List<IClientScreenModule> getHelpingScreenModules() {
        if (helpingScreenModules == null) {
            helpingScreenModules = new ArrayList<IClientScreenModule>();
            ScreenTileEntity.addLine("Read me", 0x7799FF, true);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Sneak-right click for", 0xFFFFFF, false);
            ScreenTileEntity.addLine("GUI and insertion of", 0xFFFFFF, false);
            ScreenTileEntity.addLine("modules", 0xFFFFFF, false);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Use Screen Controller", 0xFFFFFF, false);
            ScreenTileEntity.addLine("to power screens", 0xFFFFFF, false);
            ScreenTileEntity.addLine("remotely", 0xFFFFFF, false);
        }
        return helpingScreenModules;
    }

    private static void addLine(String s, int color, boolean large) {
        TextClientScreenModule t1 = new TextClientScreenModule();
        t1.setLine(s);
        t1.setColor(color);
        t1.setLarge(large);
        helpingScreenModules.add(t1);
    }

    public List<IClientScreenModule> getClientScreenModules() {
        if (this.clientScreenModules == null) {
            this.needsServerData = false;
            this.showHelp = true;
            this.clientScreenModules = new ArrayList<IClientScreenModule>();
            for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
                ItemStack itemStack = this.inventoryHelper.getStackInSlot(i);
                if (ItemStackTools.isValid((ItemStack)itemStack) && itemStack.func_77973_b() instanceof IModuleProvider) {
                    IClientScreenModule clientScreenModule;
                    IModuleProvider moduleProvider = (IModuleProvider)itemStack.func_77973_b();
                    try {
                        clientScreenModule = moduleProvider.getClientScreenModule().newInstance();
                    }
                    catch (InstantiationException e) {
                        Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                        continue;
                    }
                    clientScreenModule.setupFromNBT(itemStack.func_77978_p(), this.func_145831_w().field_73011_w.getDimension(), this.func_174877_v());
                    this.clientScreenModules.add(clientScreenModule);
                    if (clientScreenModule.needsServerData()) {
                        this.needsServerData = true;
                    }
                    this.showHelp = false;
                    continue;
                }
                this.clientScreenModules.add(null);
            }
        }
        return this.clientScreenModules;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public boolean isNeedsServerData() {
        return this.needsServerData;
    }

    public int getTotalRfPerTick() {
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.totalRfPerTick;
    }

    public List<IScreenModule> getScreenModules() {
        if (this.screenModules == null) {
            this.totalRfPerTick = 0;
            this.screenModules = new ArrayList<IScreenModule>();
            for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
                ItemStack itemStack = this.inventoryHelper.getStackInSlot(i);
                if (ItemStackTools.isValid((ItemStack)itemStack) && itemStack.func_77973_b() instanceof IModuleProvider) {
                    IScreenModule screenModule;
                    IModuleProvider moduleProvider = (IModuleProvider)itemStack.func_77973_b();
                    try {
                        screenModule = moduleProvider.getServerScreenModule().newInstance();
                    }
                    catch (InstantiationException e) {
                        Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                        continue;
                    }
                    screenModule.setupFromNBT(itemStack.func_77978_p(), this.func_145831_w().field_73011_w.getDimension(), this.func_174877_v());
                    this.screenModules.add(screenModule);
                    this.totalRfPerTick += screenModule.getRfPerTick();
                    continue;
                }
                this.screenModules.add(null);
            }
        }
        return this.screenModules;
    }

    public Map<Integer, IModuleData> getScreenData(long millis) {
        HashMap<Integer, IModuleData> map = new HashMap<Integer, IModuleData>();
        List<IScreenModule> screenModules = this.getScreenModules();
        int moduleIndex = 0;
        for (IScreenModule module : screenModules) {
            Object data;
            if (module != null && (data = module.getData(this.screenDataHelper, this.func_145831_w(), millis)) != null) {
                map.put(moduleIndex, (IModuleData)data);
            }
            ++moduleIndex;
        }
        return map;
    }

    public IScreenModule getHoveringModule() {
        if (this.hoveringModule == -1) {
            return null;
        }
        this.getScreenModules();
        if (this.hoveringModule >= 0 && this.hoveringModule < this.screenModules.size()) {
            return this.screenModules.get(this.hoveringModule);
        }
        return null;
    }

    public int getHoveringX() {
        return this.hoveringX;
    }

    public int getHoveringY() {
        return this.hoveringY;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_CLICK.equals(command)) {
            int x = args.get("x").getInteger();
            int y = args.get("y").getInteger();
            int module = args.get("module").getInteger();
            this.hitScreenServer((EntityPlayer)playerMP, x, y, module);
            return true;
        }
        if (CMD_HOVER.equals(command)) {
            this.hoveringX = args.get("x").getInteger();
            this.hoveringY = args.get("y").getInteger();
            this.hoveringModule = args.get("module").getInteger();
            return true;
        }
        if (CMD_SETBRIGHT.equals(command)) {
            boolean b = args.get("b").getBoolean();
            this.setBright(b);
            return true;
        }
        if (CMD_SETTRUETYPE.equals(command)) {
            int b = args.get("b").getInteger();
            this.setTrueTypeMode(b);
            return true;
        }
        return false;
    }

    public static class ModuleRaytraceResult {
        private final int x;
        private final int y;
        private final int currenty;
        private final int moduleIndex;

        public ModuleRaytraceResult(int moduleIndex, int x, int y, int currenty) {
            this.moduleIndex = moduleIndex;
            this.x = x;
            this.y = y;
            this.currenty = currenty;
        }

        public int getModuleIndex() {
            return this.moduleIndex;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getCurrenty() {
            return this.currenty;
        }
    }

    private static class ActivatedModule {
        private int module;
        private int ticks;
        private int x;
        private int y;

        public ActivatedModule(int module, int ticks, int x, int y) {
            this.module = module;
            this.ticks = ticks;
            this.x = x;
            this.y = y;
        }
    }
}

