/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.lib.tools.ChatTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleDataBoolean;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.StorageControlScreenModule;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class DumpScreenModule
implements IScreenModule {
    public static int COLS = 7;
    public static int ROWS = 4;
    private ItemStack[] stacks = new ItemStack[COLS * ROWS];
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private boolean oredict = false;

    public IModuleDataBoolean getData(IScreenDataHelper helper, World worldObj, long millis) {
        return null;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            for (int i = 0; i < this.stacks.length; ++i) {
                if (!tagCompound.func_74764_b("stack" + i)) continue;
                this.stacks[i] = ItemStackTools.loadFromNBT((NBTTagCompound)tagCompound.func_74775_l("stack" + i));
            }
        }
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        this.oredict = tagCompound.func_74767_n("oredict");
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
            if (dim == this.dim) {
                BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    private boolean isShown(ItemStack stack) {
        if (ItemStackTools.isEmpty((ItemStack)stack)) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (!StorageScannerTileEntity.isItemEqual(stack, s, this.oredict)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
        if (!clicked || player == null) {
            return;
        }
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "Module is not linked to storage scanner!"));
            return;
        }
        StorageScannerTileEntity scannerTileEntity = StorageControlScreenModule.getStorageScanner(this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return;
        }
        int xoffset = 5;
        if (x >= xoffset) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                if (!this.isShown(player.field_71071_by.func_70301_a(i))) continue;
                ItemStack stack = scannerTileEntity.injectStackFromScreen(player.field_71071_by.func_70301_a(i), player);
                player.field_71071_by.func_70299_a(i, stack);
            }
            player.field_71070_bA.func_75142_b();
            return;
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.DUMP_RFPERTICK;
    }
}

