/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient.helper;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.MinecraftTools;
import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.blocks.screens.IModuleGuiChanged;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ScreenModuleGuiBuilder
implements IModuleGuiBuilder {
    private Minecraft mc;
    private Gui gui;
    private NBTTagCompound currentData;
    private IModuleGuiChanged moduleGuiChanged;
    private Panel panel;
    private List<Widget> row = new ArrayList<Widget>();

    public ScreenModuleGuiBuilder(Minecraft mc, Gui gui, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged) {
        this.gui = gui;
        this.mc = mc;
        this.moduleGuiChanged = moduleGuiChanged;
        this.currentData = currentData;
        this.panel = new Panel(mc, gui).setLayout((Layout)new VerticalLayout().setVerticalMargin(5));
    }

    public NBTTagCompound getCurrentData() {
        return this.currentData;
    }

    public IModuleGuiChanged getModuleGuiChanged() {
        return this.moduleGuiChanged;
    }

    public Gui getGui() {
        return this.gui;
    }

    public ScreenModuleGuiBuilder overridePanel(Panel p) {
        this.panel = p;
        return this;
    }

    public Panel build() {
        this.nl();
        return this.panel;
    }

    @Override
    public ScreenModuleGuiBuilder label(String text) {
        Label label = new Label(this.mc, this.gui).setText(text);
        this.row.add((Widget)label);
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder leftLabel(String text) {
        Label label = new Label(this.mc, this.gui).setText(text).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.row.add((Widget)label);
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder text(String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField(this.mc, this.gui).setDesiredHeight(15)).setTooltips(tooltip)).addTextEvent((parent, newText) -> {
            this.currentData.func_74778_a(tagname, newText);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget)textField);
        if (this.currentData != null) {
            textField.setText(this.currentData.func_74779_i(tagname));
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder integer(String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField(this.mc, this.gui).setDesiredHeight(15)).setTooltips(tooltip)).addTextEvent((parent, newText) -> {
            int value;
            try {
                value = Integer.parseInt(newText);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            this.currentData.func_74768_a(tagname, value);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget)textField);
        if (this.currentData != null && this.currentData.func_74764_b(tagname)) {
            int dd = this.currentData.func_74762_e(tagname);
            textField.setText(Integer.toString(dd));
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder toggle(String tagname, String label, String ... tooltip) {
        ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, this.gui).setText(label)).setTooltips(tooltip)).setDesiredHeight(14)).setCheckMarker(true);
        toggleButton.addButtonEvent(parent -> {
            this.currentData.func_74757_a(tagname, toggleButton.isPressed());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget)toggleButton);
        if (this.currentData != null) {
            toggleButton.setPressed(this.currentData.func_74767_n(tagname));
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder toggleNegative(String tagname, String label, String ... tooltip) {
        ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, this.gui).setText(label)).setTooltips(tooltip)).setDesiredHeight(14)).setDesiredWidth(36)).setCheckMarker(true);
        toggleButton.addButtonEvent(parent -> {
            this.currentData.func_74757_a(tagname, !toggleButton.isPressed());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget)toggleButton);
        if (this.currentData != null) {
            toggleButton.setPressed(!this.currentData.func_74767_n(tagname));
        } else {
            toggleButton.setPressed(true);
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder color(String tagname, String ... tooltip) {
        int currentColor;
        ColorChoiceLabel colorSelector = ((ColorChoiceLabel)((ColorChoiceLabel)((ColorChoiceLabel)new ColorChoiceLabel(this.mc, this.gui).setTooltips(tooltip)).addColors(new Integer[]{0xFFFFFF, 0x888888, 65793, 0xFF0000, 0x880000, 65280, 34816, 255, 136, 0xFFFF00, 0x888800, 0xFF00FF, 0x880088, 65535, 34952}).setDesiredWidth(20)).setDesiredHeight(14)).addChoiceEvent((parent, newColor) -> {
            this.currentData.func_74768_a(tagname, newColor.intValue());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget)colorSelector);
        if (this.currentData != null && (currentColor = this.currentData.func_74762_e(tagname)) != 0) {
            colorSelector.setCurrentColor(Integer.valueOf(currentColor));
        }
        return this;
    }

    @Override
    public IModuleGuiBuilder choices(String tagname, String tooltip, String ... choices) {
        String currentChoice;
        ChoiceLabel choiceLabel = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.mc, this.gui).setTooltips(new String[]{tooltip})).setDesiredWidth(50)).setDesiredHeight(14);
        for (String s : choices) {
            choiceLabel.addChoices(new String[]{s});
        }
        choiceLabel.addChoiceEvent((parent, newChoice) -> {
            this.currentData.func_74778_a(tagname, newChoice);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget)choiceLabel);
        if (this.currentData != null && !(currentChoice = this.currentData.func_74779_i(tagname)).isEmpty()) {
            choiceLabel.setChoice(currentChoice);
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder format(String tagname) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupFormatCombo(this.mc, this.gui, tagname, this.currentData, this.moduleGuiChanged);
        this.row.add((Widget)label);
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder mode(String componentName) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupModeCombo(this.mc, this.gui, componentName, this.currentData, this.moduleGuiChanged);
        this.row.add((Widget)label);
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder block(String tagnamePos) {
        String monitoring;
        if (this.currentData.func_74764_b(tagnamePos + "x")) {
            int dim = this.currentData.func_74764_b(tagnamePos + "dim") ? this.currentData.func_74762_e(tagnamePos + "dim") : this.currentData.func_74762_e("dim");
            World world = MinecraftTools.getPlayer((Minecraft)this.mc).func_130014_f_();
            if (dim == world.field_73011_w.getDimension()) {
                int x = this.currentData.func_74762_e(tagnamePos + "x");
                int y = this.currentData.func_74762_e(tagnamePos + "y");
                int z = this.currentData.func_74762_e(tagnamePos + "z");
                monitoring = this.currentData.func_74779_i(tagnamePos + "name");
                Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                this.row.add((Widget)new BlockRender(this.mc, this.gui).setRenderItem((Object)block).setDesiredWidth(20));
                this.row.add((Widget)new Label(this.mc, this.gui).setText(x + "," + y + "," + z).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(150));
            } else {
                monitoring = "<unreachable>";
            }
        } else {
            monitoring = "<not set>";
        }
        this.row.add((Widget)new Label(this.mc, this.gui).setText(monitoring));
        return this;
    }

    @Override
    public IModuleGuiBuilder ghostStack(final String tagname) {
        ItemStack stack = ItemStackTools.getEmptyStack();
        if (this.currentData.func_74764_b(tagname)) {
            stack = ItemStackTools.loadFromNBT((NBTTagCompound)this.currentData.func_74775_l(tagname));
        }
        final BlockRender blockRender = (BlockRender)((BlockRender)((BlockRender)((BlockRender)new BlockRender(this.mc, this.gui).setRenderItem((Object)stack).setDesiredWidth(18)).setDesiredHeight(18)).setFilledRectThickness(1)).setFilledBackground(-11184811);
        this.row.add((Widget)blockRender);
        blockRender.addSelectionEvent(new BlockRenderEvent(){

            public void select(Widget widget) {
                ItemStack holding = MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x()).field_71071_by.func_70445_o();
                if (ItemStackTools.isEmpty((ItemStack)holding)) {
                    ScreenModuleGuiBuilder.this.currentData.func_82580_o(tagname);
                    blockRender.setRenderItem(null);
                } else {
                    ItemStack copy = holding.func_77946_l();
                    ItemStackTools.setStackSize((ItemStack)copy, (int)1);
                    blockRender.setRenderItem((Object)copy);
                    NBTTagCompound tc = new NBTTagCompound();
                    copy.func_77955_b(tc);
                    ScreenModuleGuiBuilder.this.currentData.func_74782_a(tagname, (NBTBase)tc);
                }
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }

            public void doubleClick(Widget widget) {
            }
        });
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder nl() {
        if (this.row.size() == 1) {
            this.panel.addChild(this.row.get(0).setDesiredHeight(16));
            this.row.clear();
        } else if (!this.row.isEmpty()) {
            Panel rowPanel = (Panel)new Panel(this.mc, this.gui).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
            for (Widget widget : this.row) {
                rowPanel.addChild(widget);
            }
            this.panel.addChild((Widget)rowPanel);
            this.row.clear();
        }
        return this;
    }

    private static ChoiceLabel setupFormatCombo(Minecraft mc, Gui gui, String tagname, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged) {
        String modeFull = FormatStyle.MODE_FULL.getName();
        String modeCompact = FormatStyle.MODE_COMPACT.getName();
        String modeCommas = FormatStyle.MODE_COMMAS.getName();
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredWidth(58)).setDesiredHeight(14)).addChoices(new String[]{modeFull, modeCompact, modeCommas}).setChoiceTooltip(modeFull, new String[]{"Full format: 3123555"}).setChoiceTooltip(modeCompact, new String[]{"Compact format: 3.1M"}).setChoiceTooltip(modeCommas, new String[]{"Comma format: 3,123,555"}).addChoiceEvent((parent, newChoice) -> {
            currentData.func_74768_a(tagname, FormatStyle.getStyle(newChoice).ordinal());
            moduleGuiChanged.updateData();
        });
        FormatStyle currentFormat = FormatStyle.values()[currentData.func_74762_e(tagname)];
        modeButton.setChoice(currentFormat.getName());
        return modeButton;
    }

    private static ChoiceLabel setupModeCombo(Minecraft mc, Gui gui, String componentName, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged) {
        String modeNone = "None";
        String modePertick = componentName + "/t";
        String modePct = componentName + "%";
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredWidth(50)).setDesiredHeight(14)).addChoices(new String[]{modeNone, componentName, modePertick, modePct}).setChoiceTooltip(modeNone, new String[]{"No text is shown"}).setChoiceTooltip(componentName, new String[]{"Show the amount of " + componentName}).setChoiceTooltip(modePertick, new String[]{"Show the average " + componentName + "/tick", "gain or loss"}).setChoiceTooltip(modePct, new String[]{"Show the amount of " + componentName, "as a percentage"}).addChoiceEvent((parent, newChoice) -> {
            if (componentName.equals(newChoice)) {
                currentData.func_74757_a("showdiff", false);
                currentData.func_74757_a("showpct", false);
                currentData.func_74757_a("hidetext", false);
            } else if (modePertick.equals(newChoice)) {
                currentData.func_74757_a("showdiff", true);
                currentData.func_74757_a("showpct", false);
                currentData.func_74757_a("hidetext", false);
            } else if (modePct.equals(newChoice)) {
                currentData.func_74757_a("showdiff", false);
                currentData.func_74757_a("showpct", true);
                currentData.func_74757_a("hidetext", false);
            } else {
                currentData.func_74757_a("showdiff", false);
                currentData.func_74757_a("showpct", false);
                currentData.func_74757_a("hidetext", true);
            }
            moduleGuiChanged.updateData();
        });
        if (currentData.func_74767_n("hidetext")) {
            modeButton.setChoice(modeNone);
        } else if (currentData.func_74767_n("showdiff")) {
            modeButton.setChoice(modePertick);
        } else if (currentData.func_74767_n("showpct")) {
            modeButton.setChoice(modePct);
        } else {
            modeButton.setChoice(componentName);
        }
        return modeButton;
    }
}

