/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.tools.ChatTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.SoundTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.api.general.IInventoryTracker;
import mcjty.rftools.api.storage.IStorageScanner;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.blocks.storagemonitor.CachedItemCount;
import mcjty.rftools.blocks.storagemonitor.CachedItemKey;
import mcjty.rftools.blocks.storagemonitor.InventoryAccessSettings;
import mcjty.rftools.blocks.storagemonitor.StorageScannerConfiguration;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import mcjty.rftools.craftinggrid.TileEntityItemSource;
import mcjty.rftools.jei.JEIRecipeAcceptor;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class StorageScannerTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable,
CraftingGridProvider,
JEIRecipeAcceptor,
IStorageScanner {
    public static final String CMD_SETRADIUS = "setRadius";
    public static final String CMD_UP = "up";
    public static final String CMD_TOP = "top";
    public static final String CMD_DOWN = "down";
    public static final String CMD_BOTTOM = "bottom";
    public static final String CMD_REMOVE = "remove";
    public static final String CMD_TOGGLEROUTABLE = "toggleRoutable";
    public static final String CMD_TOGGLEEXPORT = "toggleExport";
    public static final String CMD_SETVIEW = "setView";
    public static final String CMD_CLEARGRID = "clearGrid";
    private static final int[] SLOTS = new int[]{0, 1, 2};
    public static final int XNETDELAY = 40;
    private List<BlockPos> inventories = new ArrayList<BlockPos>();
    private Set<BlockPos> inventoriesFromXNet = new HashSet<BlockPos>();
    private Map<BlockPos, InventoryAccessSettings> xnetAccess = Collections.emptyMap();
    private int xnetDelay = 40;
    private Map<CachedItemKey, CachedItemCount> cachedCounts = new HashMap<CachedItemKey, CachedItemCount>();
    private Set<BlockPos> routable = new HashSet<BlockPos>();
    private int radius = 1;
    private Integer monitorDim;
    private boolean exportToCurrent = false;
    private BlockPos lastSelectedInventory = null;
    private boolean openWideView = true;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, StorageScannerContainer.factory, 3);
    private CraftingGrid craftingGrid = new CraftingGrid();

    public StorageScannerTileEntity() {
        super(StorageScannerConfiguration.MAXENERGY, StorageScannerConfiguration.RECEIVEPERTICK);
        this.monitorDim = null;
        this.radius = StorageScannerConfiguration.xnetRequired && RFTools.instance.xnet ? 0 : 1;
    }

    public StorageScannerTileEntity(EntityPlayer entityPlayer, int monitordim) {
        super(StorageScannerConfiguration.MAXENERGY, StorageScannerConfiguration.RECEIVEPERTICK);
        this.monitorDim = monitordim;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public int[] craft(EntityPlayerMP player, int n, boolean test) {
        CraftingRecipe activeRecipe = this.craftingGrid.getActiveRecipe();
        return this.craft(player, n, test, activeRecipe);
    }

    @Nonnull
    public int[] craft(EntityPlayerMP player, int n, boolean test, CraftingRecipe activeRecipe) {
        TileEntityItemSource itemSource = new TileEntityItemSource().addInventory((IInventory)player.field_71071_by, 0);
        this.inventories.stream().filter(p -> this.isOutputFromGui((BlockPos)p) && this.isRoutable((BlockPos)p)).forEachOrdered(p -> {
            TileEntity tileEntity = this.func_145831_w().func_175625_s(p);
            if (!(tileEntity instanceof StorageScannerTileEntity)) {
                itemSource.add(tileEntity, 0);
            }
        });
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, activeRecipe, itemSource);
        }
        StorageCraftingTools.craftItems(player, n, activeRecipe, itemSource);
        return new int[0];
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().func_70299_a(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            ItemStack stack;
            --this.xnetDelay;
            if (this.xnetDelay < 0) {
                this.xnetAccess = Collections.emptyMap();
                this.xnetDelay = 40;
            }
            if (this.inventoryHelper.containsItem(0)) {
                if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerInsert) {
                    return;
                }
                stack = this.inventoryHelper.getStackInSlot(0);
                stack = this.injectStackInternal(stack, this.exportToCurrent, (Function<BlockPos, Boolean>)((Function)this::isInputFromGui));
                this.inventoryHelper.setInventorySlotContents(64, 0, stack);
                this.consumeEnergy(StorageScannerConfiguration.rfPerInsert);
            }
            if (this.inventoryHelper.containsItem(2)) {
                if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerInsert) {
                    return;
                }
                stack = this.inventoryHelper.getStackInSlot(2);
                stack = this.injectStackInternal(stack, false, (Function<BlockPos, Boolean>)((Function)this::isInputFromAuto));
                this.inventoryHelper.setInventorySlotContents(64, 2, stack);
                this.consumeEnergy(StorageScannerConfiguration.rfPerInsert);
            }
        }
    }

    public ItemStack injectStackFromScreen(ItemStack stack, EntityPlayer player) {
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerInsert) {
            ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "Not enough power to insert items!"));
            return stack;
        }
        if (!this.checkForRoutableInventories()) {
            ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "There are no routable inventories!"));
            return stack;
        }
        if (ItemStackTools.isEmpty((ItemStack)(stack = this.injectStackInternal(stack, false, (Function<BlockPos, Boolean>)((Function)this::isInputFromScreen))))) {
            this.consumeEnergy(StorageScannerConfiguration.rfPerInsert);
            SoundTools.playSound((World)this.func_145831_w(), (SoundEvent)SoundEvents.field_187638_cR, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)3.0);
        }
        return stack;
    }

    private boolean checkForRoutableInventories() {
        return this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && !p.equals((Object)this.func_174877_v()) && this.isRoutable((BlockPos)p) && RFToolsTools.chunkLoaded(this.func_145831_w(), p)).anyMatch(p -> this.func_145831_w().func_175625_s(p) != null);
    }

    private ItemStack injectStackInternal(ItemStack stack, boolean toSelected, @Nonnull Function<BlockPos, Boolean> testAccess) {
        if (toSelected && this.lastSelectedInventory != null && this.lastSelectedInventory.func_177956_o() != -1) {
            TileEntity te2 = this.func_145831_w().func_175625_s(this.lastSelectedInventory);
            if (te2 != null && !(te2 instanceof StorageScannerTileEntity) && ((Boolean)testAccess.apply((Object)this.lastSelectedInventory)).booleanValue() && this.getInputMatcher(this.lastSelectedInventory).test(stack) && ItemStackTools.isEmpty((ItemStack)(stack = InventoryHelper.insertItem((World)this.func_145831_w(), (BlockPos)this.lastSelectedInventory, null, (ItemStack)stack)))) {
                return stack;
            }
            return stack;
        }
        ItemStack finalStack = stack;
        Iterator iterator = this.inventories.stream().filter(p -> (Boolean)testAccess.apply(p) != false && !p.equals((Object)this.func_174877_v()) && this.isRoutable((BlockPos)p) && RFToolsTools.chunkLoaded(this.func_145831_w(), p) && this.getInputMatcher((BlockPos)p).test(finalStack)).map(p -> this.func_145831_w().func_175625_s(p)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity)).iterator();
        while (ItemStackTools.isValid((ItemStack)stack) && iterator.hasNext()) {
            TileEntity te3 = (TileEntity)iterator.next();
            stack = InventoryHelper.insertItem((World)this.func_145831_w(), (BlockPos)te3.func_174877_v(), null, (ItemStack)stack);
        }
        return stack;
    }

    public void giveToPlayerFromScreen(ItemStack stack, boolean single, EntityPlayer player, boolean oredict) {
        if (ItemStackTools.isEmpty((ItemStack)stack)) {
            return;
        }
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerRequest) {
            ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "Not enough power to request items!"));
            return;
        }
        Set<Integer> oredictMatches = StorageScannerTileEntity.getOredictMatchers(stack, oredict);
        int[] cnt = new int[]{single ? 1 : stack.func_77976_d()};
        int orig = cnt[0];
        this.inventories.stream().filter(this::isOutputFromScreen).map(this::getItemHandlerAt).filter(Objects::nonNull).forEachOrdered(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack itemStack = handler.getStackInSlot(i);
                if (!StorageScannerTileEntity.isItemEqual(stack, itemStack, oredictMatches)) continue;
                ItemStack received = handler.extractItem(i, cnt[0], false);
                this.giveItemToPlayer(player, cnt, received);
            }
        });
        if (orig != cnt[0]) {
            this.consumeEnergy(StorageScannerConfiguration.rfPerRequest);
            SoundTools.playSound((World)this.func_145831_w(), (SoundEvent)SoundEvents.field_187638_cR, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)1.0);
        }
    }

    private boolean giveItemToPlayer(EntityPlayer player, int[] cnt, ItemStack received) {
        if (ItemStackTools.isValid((ItemStack)received) && cnt[0] > 0) {
            cnt[0] = cnt[0] - ItemStackTools.getStackSize((ItemStack)received);
            this.giveToPlayer(received, player);
            return true;
        }
        return false;
    }

    private boolean giveToPlayer(ItemStack stack, EntityPlayer player) {
        if (ItemStackTools.isEmpty((ItemStack)stack)) {
            return false;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_70099_a(stack, 1.05f);
        }
        return true;
    }

    @Override
    public int countItems(Predicate<ItemStack> matcher, boolean starred, @Nullable Integer maxneeded) {
        int[] cc = new int[]{0};
        this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && (!starred || this.isRoutable((BlockPos)p)) && RFToolsTools.chunkLoaded(this.func_145831_w(), p)).map(p -> this.func_145831_w().func_175625_s(p)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity)).allMatch(te -> {
            InventoryHelper.getItems((TileEntity)te, (Predicate)matcher).forEach(s -> {
                cc[0] = cc[0] + ItemStackTools.getStackSize((ItemStack)s);
            });
            return maxneeded == null || cc[0] < maxneeded;
        });
        return cc[0];
    }

    @Override
    public int countItems(ItemStack match, boolean routable, boolean oredict) {
        return this.countItems(match, routable, oredict, null);
    }

    @Override
    public int countItems(ItemStack stack, boolean starred, boolean oredict, @Nullable Integer maxneeded) {
        if (ItemStackTools.isEmpty((ItemStack)stack)) {
            return 0;
        }
        Set<Integer> oredictMatches = StorageScannerTileEntity.getOredictMatchers(stack, oredict);
        Iterator iterator = this.inventories.stream().filter(p -> this.isValid((BlockPos)p) && (!starred || this.isRoutable((BlockPos)p)) && RFToolsTools.chunkLoaded(this.func_145831_w(), p)).map(p -> this.func_145831_w().func_175625_s(p)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity)).iterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            TileEntity te2 = (TileEntity)iterator.next();
            Integer cachedCount = null;
            if (te2 instanceof IInventoryTracker) {
                Integer oldVersion;
                IInventoryTracker tracker = (IInventoryTracker)te2;
                CachedItemCount itemCount = this.cachedCounts.get(new CachedItemKey(te2.func_174877_v(), stack.func_77973_b(), stack.func_77960_j()));
                if (itemCount != null && (oldVersion = Integer.valueOf(itemCount.getVersion())).intValue() == tracker.getVersion()) {
                    cachedCount = itemCount.getCount();
                }
            }
            if (cachedCount != null) {
                cnt += cachedCount.intValue();
            } else {
                int[] cc = new int[]{0};
                InventoryHelper.getItems((TileEntity)te2, s -> StorageScannerTileEntity.isItemEqual(stack, s, oredictMatches)).forEach(s -> {
                    cc[0] = cc[0] + ItemStackTools.getStackSize((ItemStack)s);
                });
                if (te2 instanceof IInventoryTracker) {
                    IInventoryTracker tracker = (IInventoryTracker)te2;
                    this.cachedCounts.put(new CachedItemKey(te2.func_174877_v(), stack.func_77973_b(), stack.func_77960_j()), new CachedItemCount(tracker.getVersion(), cc[0]));
                }
                cnt += cc[0];
            }
            if (maxneeded == null || cnt < maxneeded) continue;
            break;
        }
        return cnt;
    }

    private static Set<Integer> getOredictMatchers(ItemStack stack, boolean oredict) {
        HashSet<Integer> oredictMatches = new HashSet<Integer>();
        if (oredict) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                oredictMatches.add(id);
            }
        }
        return oredictMatches;
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other, boolean oredict) {
        return StorageScannerTileEntity.isItemEqual(thisItem, other, StorageScannerTileEntity.getOredictMatchers(thisItem, oredict));
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other, Set<Integer> oreDictMatchers) {
        int[] oreIDs;
        if (ItemStackTools.isEmpty((ItemStack)other)) {
            return false;
        }
        if (oreDictMatchers.isEmpty()) {
            return thisItem.func_77969_a(other);
        }
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)other)) {
            if (!oreDictMatchers.contains(id)) continue;
            return true;
        }
        return false;
    }

    public Set<BlockPos> performSearch(String search) {
        String finalSearch = search;
        HashSet<BlockPos> output = new HashSet<BlockPos>();
        this.inventories.stream().filter(this::isValid).map(p -> this.func_145831_w().func_175625_s(p)).filter(te -> te != null && !(te instanceof StorageScannerTileEntity)).forEach(te -> InventoryHelper.getItems((TileEntity)te, s -> s.func_82833_r().toLowerCase().contains(finalSearch)).forEach(s -> output.add(te.func_174877_v())));
        return output;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int v) {
        this.radius = v;
        if (StorageScannerConfiguration.xnetRequired && RFTools.instance.xnet) {
            this.radius = 0;
        }
        this.markDirtyClient();
    }

    public boolean isOpenWideView() {
        return this.openWideView;
    }

    public void setOpenWideView(boolean openWideView) {
        this.openWideView = openWideView;
        this.markDirtyClient();
    }

    public boolean isExportToCurrent() {
        return this.exportToCurrent;
    }

    public void setExportToCurrent(boolean exportToCurrent) {
        this.exportToCurrent = exportToCurrent;
        this.func_70296_d();
    }

    private void toggleExportRoutable() {
        this.exportToCurrent = !this.exportToCurrent;
        this.markDirtyClient();
    }

    public boolean isRoutable(BlockPos p) {
        return this.routable.contains(p);
    }

    public boolean isValid(BlockPos p) {
        if (this.xnetAccess.containsKey(p)) {
            return true;
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromGui(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputGui();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromScreen(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputScreen();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isOutputFromAuto(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockOutputAuto();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public Predicate<ItemStack> getInputMatcher(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return settings.getMatcher();
        }
        return stack -> true;
    }

    public boolean isInputFromGui(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputGui();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isInputFromScreen(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputScreen();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public boolean isInputFromAuto(BlockPos p) {
        InventoryAccessSettings settings = this.xnetAccess.get(p);
        if (settings != null) {
            return !settings.isBlockInputAuto();
        }
        return !this.inventoriesFromXNet.contains(p);
    }

    public void toggleRoutable(BlockPos p) {
        if (this.routable.contains(p)) {
            this.routable.remove(p);
        } else {
            this.routable.add(p);
        }
        this.markDirtyClient();
    }

    public void register(Map<BlockPos, InventoryAccessSettings> access) {
        this.xnetAccess = access;
        this.xnetDelay = 40;
    }

    private void moveUp(int index) {
        if (index <= 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p1 = this.inventories.get(index - 1);
        BlockPos p2 = this.inventories.get(index);
        this.inventories.set(index - 1, p2);
        this.inventories.set(index, p1);
        this.func_70296_d();
    }

    private void moveTop(int index) {
        if (index <= 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        this.inventories.remove(index);
        this.inventories.add(0, p);
        this.func_70296_d();
    }

    private void moveDown(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size() - 1) {
            return;
        }
        BlockPos p1 = this.inventories.get(index);
        BlockPos p2 = this.inventories.get(index + 1);
        this.inventories.set(index, p2);
        this.inventories.set(index + 1, p1);
        this.func_70296_d();
    }

    private void moveBottom(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size() - 1) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        this.inventories.remove(index);
        this.inventories.add(p);
        this.func_70296_d();
    }

    private void removeInventory(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.inventories.size()) {
            return;
        }
        BlockPos p = this.inventories.get(index);
        if (this.inventoriesFromXNet.contains(p)) {
            return;
        }
        this.inventories.remove(index);
        this.func_70296_d();
    }

    public void clearCachedCounts() {
        this.cachedCounts.clear();
    }

    public Stream<BlockPos> findInventories() {
        if (RFTools.instance.xnet && StorageScannerConfiguration.xnetRequired) {
            this.radius = 0;
        }
        this.cachedCounts.clear();
        this.inventoriesFromXNet.clear();
        List<BlockPos> old = this.inventories;
        HashSet<BlockPos> oldAdded = new HashSet<BlockPos>();
        this.inventories = new ArrayList<BlockPos>();
        for (BlockPos p : old) {
            TileEntity te;
            if (!this.xnetAccess.containsKey(p) && !this.inRange(p) || !InventoryHelper.isInventory((TileEntity)(te = this.func_145831_w().func_175625_s(p))) || te instanceof StorageScannerTileEntity) continue;
            this.inventories.add(p);
            oldAdded.add(p);
        }
        for (int x = this.func_174877_v().func_177958_n() - this.radius; x <= this.func_174877_v().func_177958_n() + this.radius; ++x) {
            for (int z = this.func_174877_v().func_177952_p() - this.radius; z <= this.func_174877_v().func_177952_p() + this.radius; ++z) {
                for (int y = this.func_174877_v().func_177956_o() - this.radius; y <= this.func_174877_v().func_177956_o() + this.radius; ++y) {
                    BlockPos p = new BlockPos(x, y, z);
                    this.inventoryAddNew(oldAdded, p);
                }
            }
        }
        for (BlockPos p : this.xnetAccess.keySet()) {
            this.inventoryAddNew(oldAdded, p);
            this.inventoriesFromXNet.add(p);
        }
        return this.getAllInventories();
    }

    public Stream<BlockPos> getAllInventories() {
        return this.inventories.stream().filter(this::isValid);
    }

    private void inventoryAddNew(Set<BlockPos> oldAdded, BlockPos p) {
        TileEntity te;
        if (!oldAdded.contains(p) && InventoryHelper.isInventory((TileEntity)(te = this.func_145831_w().func_175625_s(p))) && !(te instanceof StorageScannerTileEntity) && !this.inventories.contains(p)) {
            this.inventories.add(p);
        }
    }

    private boolean inRange(BlockPos p) {
        return p.func_177958_n() >= this.func_174877_v().func_177958_n() - this.radius && p.func_177958_n() <= this.func_174877_v().func_177958_n() + this.radius && p.func_177956_o() >= this.func_174877_v().func_177956_o() - this.radius && p.func_177956_o() <= this.func_174877_v().func_177956_o() + this.radius && p.func_177952_p() >= this.func_174877_v().func_177952_p() - this.radius && p.func_177952_p() <= this.func_174877_v().func_177952_p() + this.radius;
    }

    @Override
    public ItemStack requestItem(Predicate<ItemStack> matcher, boolean simulate, int amount, boolean doRoutable) {
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerRequest) {
            return ItemStackTools.getEmptyStack();
        }
        return this.inventories.stream().filter(p -> this.isOutputFromAuto((BlockPos)p) && (!doRoutable || this.isRoutable((BlockPos)p))).map(this::getItemHandlerAt).filter(Objects::nonNull).map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack received;
                ItemStack itemStack = handler.getStackInSlot(i);
                if (!matcher.test(itemStack) || !ItemStackTools.isValid((ItemStack)(received = handler.extractItem(i, amount, simulate)))) continue;
                return received.func_77946_l();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(ItemStackTools.getEmptyStack());
    }

    @Override
    public ItemStack requestItem(ItemStack match, int amount, boolean doRoutable, boolean oredict) {
        if (ItemStackTools.isEmpty((ItemStack)match)) {
            return ItemStackTools.getEmptyStack();
        }
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerRequest) {
            return ItemStackTools.getEmptyStack();
        }
        Set<Integer> oredictMatches = StorageScannerTileEntity.getOredictMatchers(match, oredict);
        ItemStack[] result = new ItemStack[]{ItemStackTools.getEmptyStack()};
        int[] cnt = new int[]{match.func_77976_d() < amount ? match.func_77976_d() : amount};
        this.inventories.stream().filter(p -> this.isOutputFromAuto((BlockPos)p) && !doRoutable || this.isRoutable((BlockPos)p)).map(this::getItemHandlerAt).filter(Objects::nonNull).allMatch(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack received;
                ItemStack itemStack = handler.getStackInSlot(i);
                if (!StorageScannerTileEntity.isItemEqual(match, itemStack, oredictMatches) || !ItemStackTools.isValid((ItemStack)(received = handler.extractItem(i, cnt[0], false)))) continue;
                if (ItemStackTools.isEmpty((ItemStack)result[0])) {
                    result[0] = received;
                } else {
                    ItemStackTools.incStackSize((ItemStack)result[0], (int)ItemStackTools.getStackSize((ItemStack)received));
                }
                cnt[0] = cnt[0] - ItemStackTools.getStackSize((ItemStack)received);
            }
            return cnt[0] > 0;
        });
        if (ItemStackTools.isValid((ItemStack)result[0])) {
            this.consumeEnergy(StorageScannerConfiguration.rfPerRequest);
        }
        return result[0];
    }

    @Nullable
    private IItemHandler getItemHandlerAt(BlockPos p) {
        if (!RFToolsTools.chunkLoaded(this.func_145831_w(), p)) {
            return null;
        }
        TileEntity te = this.func_145831_w().func_175625_s(p);
        if (te == null || te instanceof StorageScannerTileEntity) {
            return null;
        }
        return StorageScannerTileEntity.getItemHandlerAt(te, null);
    }

    @Nullable
    private static IItemHandler getItemHandlerAt(@Nullable TileEntity te, EnumFacing intSide) {
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide);
            if (handler != null) {
                return handler;
            }
        } else {
            if (te instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)te;
                return new SidedInvWrapper(sidedInventory, intSide);
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                return new InvWrapper(inventory);
            }
        }
        return null;
    }

    @Override
    public int insertItem(ItemStack stack) {
        ItemStack s = this.insertItem(stack, false);
        return ItemStackTools.getStackSize((ItemStack)s);
    }

    @Override
    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (this.getEnergyStored(EnumFacing.DOWN) < StorageScannerConfiguration.rfPerInsert) {
            return stack;
        }
        ItemStack toInsert = stack.func_77946_l();
        Iterator iterator = this.inventories.stream().filter(p -> this.isInputFromAuto((BlockPos)p) && !p.equals((Object)this.func_174877_v()) && this.isRoutable((BlockPos)p) && this.getInputMatcher((BlockPos)p).test(stack)).map(this::getItemHandlerAt).filter(Objects::nonNull).iterator();
        while (ItemStackTools.isValid((ItemStack)toInsert) && iterator.hasNext()) {
            IItemHandler handler = (IItemHandler)iterator.next();
            toInsert = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)toInsert, (boolean)simulate);
        }
        this.consumeEnergy(StorageScannerConfiguration.rfPerInsert);
        return toInsert;
    }

    private ItemStack requestStackFromInv(BlockPos invPos, ItemStack requested, Integer[] todo, ItemStack outSlot) {
        TileEntity tileEntity = this.func_145831_w().func_175625_s(invPos);
        if (tileEntity instanceof StorageScannerTileEntity) {
            return outSlot;
        }
        int size = InventoryHelper.getInventorySize((TileEntity)tileEntity);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = ItemStackTools.getStack((TileEntity)tileEntity, (int)i);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)requested, (ItemStack)stack)) continue;
            ItemStack extracted = ItemStackTools.extractItem((TileEntity)tileEntity, (int)i, (int)todo[0]);
            Integer[] integerArray = todo;
            Integer.valueOf(integerArray[0] - ItemStackTools.getStackSize((ItemStack)extracted));
            if (ItemStackTools.isEmpty((ItemStack)outSlot)) {
                outSlot = extracted;
            } else {
                ItemStackTools.incStackSize((ItemStack)outSlot, (int)ItemStackTools.getStackSize((ItemStack)extracted));
            }
            if (todo[0] == 0) break;
        }
        return outSlot;
    }

    public void requestStack(BlockPos invPos, ItemStack requested, int amount, EntityPlayer player) {
        int rf = StorageScannerConfiguration.rfPerRequest;
        if (amount >= 0) {
            rf /= 10;
        }
        if (amount == -1) {
            amount = requested.func_77976_d();
        }
        if (this.getEnergyStored(EnumFacing.DOWN) < rf) {
            return;
        }
        Integer[] todo = new Integer[]{amount};
        ItemStack outSlot = this.inventoryHelper.getStackInSlot(1);
        if (ItemStackTools.isValid((ItemStack)outSlot)) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)outSlot, (ItemStack)requested)) {
                return;
            }
            if (ItemStackTools.getStackSize((ItemStack)outSlot) >= requested.func_77976_d()) {
                return;
            }
            todo[0] = Math.min(todo[0], requested.func_77976_d() - ItemStackTools.getStackSize((ItemStack)outSlot));
        }
        if (invPos.func_177956_o() == -1) {
            Iterator iterator = this.inventories.stream().filter(p -> this.isOutputFromGui((BlockPos)p) && this.isRoutable((BlockPos)p)).iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = (BlockPos)iterator.next();
                outSlot = this.requestStackFromInv(blockPos, requested, todo, outSlot);
                if (todo[0] != 0) continue;
                break;
            }
        } else if (this.isOutputFromGui(invPos)) {
            outSlot = this.requestStackFromInv(invPos, requested, todo, outSlot);
        }
        if (todo[0] == amount) {
            return;
        }
        this.consumeEnergy(rf);
        this.func_70299_a(1, outSlot);
        if (StorageScannerConfiguration.requestStraightToInventory && player.field_71071_by.func_70441_a(outSlot)) {
            this.func_70299_a(1, ItemStackTools.getEmptyStack());
        }
    }

    private void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, ItemStack stack) {
        if (ItemStackTools.isEmpty((ItemStack)stack)) {
            return;
        }
        if (foundItems.contains(stack.func_77973_b())) {
            for (ItemStack s : stacks) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                ItemStackTools.incStackSize((ItemStack)s, (int)ItemStackTools.getStackSize((ItemStack)stack));
                return;
            }
        }
        stacks.add(stack.func_77946_l());
        foundItems.add(stack.func_77973_b());
    }

    public List<ItemStack> getInventoryForBlock(BlockPos cpos) {
        HashSet<Item> foundItems = new HashSet<Item>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.lastSelectedInventory = cpos;
        if (cpos.func_177956_o() == -1) {
            for (BlockPos blockPos : this.inventories) {
                if (!this.routable.contains(blockPos)) continue;
                this.addItemsFromInventory(blockPos, foundItems, stacks);
            }
        } else {
            this.addItemsFromInventory(cpos, foundItems, stacks);
        }
        return stacks;
    }

    private void addItemsFromInventory(BlockPos cpos, Set<Item> foundItems, List<ItemStack> stacks) {
        TileEntity tileEntity = this.func_145831_w().func_175625_s(cpos);
        IItemHandler handler = StorageScannerTileEntity.getItemHandlerAt(tileEntity, null);
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                this.addItemStack(stacks, foundItems, handler.getStackInSlot(i));
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        BlockPos c;
        NBTTagCompound tag;
        int i;
        super.func_145839_a(tagCompound);
        NBTTagList list = tagCompound.func_150295_c("inventories", 10);
        this.inventories.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            tag = (NBTTagCompound)list.func_179238_g(i);
            c = BlockPosTools.readFromNBT((NBTTagCompound)tag, (String)"c");
            this.inventories.add(c);
        }
        list = tagCompound.func_150295_c("routable", 10);
        this.routable.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            tag = (NBTTagCompound)list.func_179238_g(i);
            c = BlockPosTools.readFromNBT((NBTTagCompound)tag, (String)"c");
            this.routable.add(c);
        }
        list = tagCompound.func_150295_c("fromxnet", 10);
        this.inventoriesFromXNet.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            tag = (NBTTagCompound)list.func_179238_g(i);
            c = BlockPosTools.readFromNBT((NBTTagCompound)tag, (String)"c");
            this.inventoriesFromXNet.add(c);
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.radius = tagCompound.func_74762_e("radius");
        this.exportToCurrent = tagCompound.func_74767_n("exportC");
        this.openWideView = tagCompound.func_74764_b("wideview") ? tagCompound.func_74767_n("wideview") : true;
        this.craftingGrid.readFromNBT(tagCompound.func_74775_l("grid"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        NBTTagCompound tag;
        super.func_189515_b(tagCompound);
        NBTTagList list = new NBTTagList();
        for (BlockPos c : this.inventories) {
            tag = BlockPosTools.writeToNBT((BlockPos)c);
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("inventories", (NBTBase)list);
        list = new NBTTagList();
        for (BlockPos c : this.routable) {
            tag = BlockPosTools.writeToNBT((BlockPos)c);
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("routable", (NBTBase)list);
        list = new NBTTagList();
        for (BlockPos c : this.inventoriesFromXNet) {
            tag = BlockPosTools.writeToNBT((BlockPos)c);
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("fromxnet", (NBTBase)list);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("radius", this.radius);
        tagCompound.func_74757_a("exportC", this.exportToCurrent);
        tagCompound.func_74757_a("wideview", this.openWideView);
        tagCompound.func_74782_a("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, ItemStackTools.getEmptyStack());
        }
        this.func_70296_d();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETRADIUS.equals(command)) {
            this.setRadius(args.get("r").getInteger());
            return true;
        }
        if (CMD_UP.equals(command)) {
            this.moveUp(args.get("index").getInteger());
            return true;
        }
        if (CMD_TOP.equals(command)) {
            this.moveTop(args.get("index").getInteger());
            return true;
        }
        if (CMD_DOWN.equals(command)) {
            this.moveDown(args.get("index").getInteger());
            return true;
        }
        if (CMD_BOTTOM.equals(command)) {
            this.moveBottom(args.get("index").getInteger());
            return true;
        }
        if (CMD_REMOVE.equals(command)) {
            this.removeInventory(args.get("index").getInteger());
            return true;
        }
        if (CMD_TOGGLEROUTABLE.equals(command)) {
            this.toggleRoutable(args.get("pos").getCoordinate());
            return true;
        }
        if (CMD_TOGGLEEXPORT.equals(command)) {
            this.toggleExportRoutable();
            return true;
        }
        if (CMD_SETVIEW.equals(command)) {
            this.setOpenWideView(args.get("b").getBoolean());
            return true;
        }
        if (CMD_CLEARGRID.equals(command)) {
            this.clearGrid();
            return true;
        }
        return false;
    }

    public boolean isDummy() {
        return this.monitorDim != null;
    }

    public BlockPos getCraftingGridContainerPos() {
        return this.func_174877_v();
    }

    public CraftingGridProvider getCraftingGridProvider() {
        return this;
    }

    public BlockPos getStorageScannerPos() {
        return this.func_174877_v();
    }

    public int getDimension() {
        if (this.isDummy()) {
            return this.monitorDim;
        }
        return this.func_145831_w().field_73011_w.getDimension();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2;
    }

    public boolean isUsable(EntityPlayer player) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return StorageScannerContainer.factory.isOutputSlot(index);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }
}

