/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import mcjty.lib.McJtyLib;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.tools.ChatTools;
import mcjty.rftools.commands.AbstractRfToolsCommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CmdSetBuffBar
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "[<x> <y>]";
    }

    @Override
    public String getCommand() {
        return "buffs";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length > 3) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "Too many parameters!"));
            return;
        }
        if (!(sender instanceof EntityPlayer)) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "This command only works as a player!"));
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        PreferencesProperties properties = McJtyLib.getPreferencesProperties((EntityPlayer)player);
        if (args.length < 3) {
            int buffX = properties.getBuffX();
            int buffY = properties.getBuffY();
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Current buffbar location: " + buffX + "," + buffY));
            return;
        }
        int x = this.fetchInt(sender, args, 1, 0);
        int y = this.fetchInt(sender, args, 2, 0);
        properties.setBuffXY(x, y);
    }
}

