/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.wheelsupport;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.WheelActionElement;
import mcjty.lib.tools.ChatTools;
import mcjty.lib.tools.InventoryTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.storage.ModularStorageItemInventory;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemInventory;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import mcjty.rftools.wheelsupport.FindBlockClient;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class FindBlockAction
implements IWheelAction {
    public static final String ACTION_FINDBLOCK = "rftools.findblock";

    public String getId() {
        return ACTION_FINDBLOCK;
    }

    public WheelActionElement createElement() {
        return new WheelActionElement(ACTION_FINDBLOCK).description("Find the block you look at out of storage", null).texture("rftools:textures/gui/wheel_actions.png", 96, 0, 96, 32, 128, 128);
    }

    public boolean performClient(EntityPlayer player, World world, @Nullable BlockPos pos, boolean extended) {
        return FindBlockClient.pickBlockClient(world, pos, player);
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public void performServer(EntityPlayer player, World world, @Nullable BlockPos pos, boolean extended) {
        if (pos != null) {
            List inventory = InventoryTools.getMainInventory((EntityPlayer)player);
            IBlockState state = world.func_180495_p(pos);
            ItemStack result = state.func_177230_c().func_185473_a(world, pos, state);
            if (result == null || ItemStackTools.isEmpty((ItemStack)result)) {
                return;
            }
            ItemStack storage = ItemStackTools.getEmptyStack();
            for (ItemStack stack : inventory) {
                if (!ItemStackTools.isValid((ItemStack)stack) || stack.func_77973_b() != ModularStorageSetup.storageModuleTabletItem) continue;
                storage = stack;
                break;
            }
            if (ItemStackTools.isEmpty((ItemStack)storage)) {
                ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "No storage tablet in inventory!"));
                return;
            }
            NBTTagCompound tagCompound = storage.func_77978_p();
            if (tagCompound == null || !tagCompound.func_74764_b("childDamage")) {
                ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "No storage module in tablet!"));
                return;
            }
            int firstEmptyStack = player.field_71071_by.func_70447_i();
            if (firstEmptyStack < 0) {
                ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "No room in inventory for block!"));
                return;
            }
            int moduleDamage = tagCompound.func_74762_e("childDamage");
            ItemStack extracted = ItemStackTools.getEmptyStack();
            if (moduleDamage == 666) {
                if (tagCompound.func_74764_b("monitorx")) {
                    int monitordim = tagCompound.func_74762_e("monitordim");
                    int monitorx = tagCompound.func_74762_e("monitorx");
                    int monitory = tagCompound.func_74762_e("monitory");
                    int monitorz = tagCompound.func_74762_e("monitorz");
                    BlockPos mpos = new BlockPos(monitorx, monitory, monitorz);
                    WorldServer w = DimensionManager.getWorld((int)monitordim);
                    if (w == null || !RFToolsTools.chunkLoaded((World)w, mpos)) {
                        ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "Storage scanner is out of range!"));
                    } else {
                        StorageScannerTileEntity scanner;
                        TileEntity te = w.func_175625_s(mpos);
                        if (te instanceof StorageScannerTileEntity && ItemStackTools.isEmpty((ItemStack)(extracted = (scanner = (StorageScannerTileEntity)te).requestItem(result, result.func_77976_d(), true, false)))) {
                            extracted = scanner.requestItem(result, result.func_77976_d(), true, true);
                        }
                    }
                } else {
                    ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "Storage module is not linked to a storage scanner!"));
                }
            } else if (moduleDamage == 6) {
                if (!tagCompound.func_74764_b("id")) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This remote storage module is not linked!"));
                } else {
                    RemoteStorageItemInventory storageInv = new RemoteStorageItemInventory(player, storage);
                    for (int i = 0; i < storageInv.func_70302_i_(); ++i) {
                        ItemStack s = storageInv.func_70301_a(i);
                        if (!ItemStackTools.isValid((ItemStack)s) || !this.stackEqualExact(result, s)) continue;
                        extracted = s;
                        storageInv.func_70299_a(i, ItemStackTools.getEmptyStack());
                        break;
                    }
                }
            } else {
                ModularStorageItemInventory storageInv = new ModularStorageItemInventory(player, storage);
                for (int i = 0; i < storageInv.func_70302_i_(); ++i) {
                    ItemStack s = storageInv.func_70301_a(i);
                    if (!ItemStackTools.isValid((ItemStack)s) || !this.stackEqualExact(result, s)) continue;
                    extracted = s;
                    storageInv.func_70299_a(i, ItemStackTools.getEmptyStack());
                    break;
                }
            }
            if (ItemStackTools.isValid((ItemStack)extracted)) {
                int currentItem = player.field_71071_by.field_70461_c;
                if (currentItem == firstEmptyStack) {
                    player.field_71071_by.func_70299_a(currentItem, extracted);
                } else {
                    player.field_71071_by.func_70299_a(firstEmptyStack, (ItemStack)inventory.get(currentItem));
                    player.field_71071_by.func_70299_a(currentItem, extracted);
                }
                player.field_71070_bA.func_75142_b();
            }
        }
    }
}

