/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockCasing;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTieredPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartGlass;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.lib.BlockFacings;
import it.zerono.mods.zerocore.lib.PropertyBlockFacings;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockMultiblockGlass
extends BlockTieredPart {
    private boolean[] _actualFacings;

    public BlockMultiblockGlass(PartType type, String blockName) {
        super(type, blockName, Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this._actualFacings = new boolean[EnumFacing.field_82609_l.length];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPostClientRegister() {
        Item item = Item.func_150898_a((Block)this);
        ResourceLocation name = this.getRegistryName();
        String domain = name.func_110624_b();
        String path = name.func_110623_a();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178440_a(Properties.TIER).func_178439_a("_" + path).func_178441_a());
        for (PartTier tier : PartTier.RELEASED_TIERS) {
            ResourceLocation location = new ResourceLocation(domain, tier.func_176610_l() + "_" + path);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)tier.toMeta(), (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
        }
    }

    @Override
    public void registerRecipes() {
        BlockMultiblockCasing casingBlock;
        EnumSet<PartTier> tiers;
        boolean useGlassReinforced = BigReactors.CONFIG.requireObsidianGlass && OreDictionaryHelper.doesOreNameExist((String)"glassReinforced");
        boolean useGlassHardened = BigReactors.CONFIG.requireObsidianGlass && OreDictionaryHelper.doesOreNameExist((String)"blockGlassHardened");
        ArrayList<String> glassTypes = new ArrayList<String>();
        if (PartType.ReactorGlass == this._type) {
            tiers = PartTier.REACTOR_TIERS;
            casingBlock = BrBlocks.reactorCasing;
        } else {
            tiers = PartTier.TURBINE_TIERS;
            casingBlock = BrBlocks.turbineHousing;
        }
        if (useGlassReinforced) {
            glassTypes.add("glassReinforced");
        }
        if (useGlassHardened) {
            glassTypes.add("blockGlassHardened");
        }
        if (!useGlassReinforced && !useGlassHardened) {
            glassTypes.add("blockGlassColorless");
        }
        for (PartTier tier : tiers) {
            ItemStack output = this.createItemStack(tier, 1);
            ItemStack casing = casingBlock.createItemStack(tier, 1);
            for (String glass : glassTypes) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{"GCG", Character.valueOf('G'), glass, Character.valueOf('C'), casing}));
            }
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this._type) {
            case ReactorGlass: {
                return new TileEntityReactorGlass();
            }
            case TurbineGlass: {
                return new TileEntityTurbinePartGlass();
            }
        }
        throw new IllegalArgumentException("Unrecognized part");
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        Block thisBlock = state.func_177230_c();
        int len = EnumFacing.field_82609_l.length;
        for (int i = 0; i < len; ++i) {
            IBlockState neighbor = world.func_180495_p(position.func_177972_a(EnumFacing.field_82609_l[i]));
            this._actualFacings[i] = thisBlock == neighbor.func_177230_c();
        }
        BlockFacings facings = BlockFacings.from((boolean[])this._actualFacings);
        return state.func_177226_a((IProperty)PropertyBlockFacings.FACINGS, (Comparable)facings.toProperty());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{PropertyBlockFacings.FACINGS});
    }

    @Override
    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a((IProperty)PropertyBlockFacings.FACINGS, (Comparable)PropertyBlockFacings.None);
    }
}

