/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.client.gui.GuiReactorRedstonePort;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.CircuitType;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.gui.container.ContainerBasic;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityReactorRedstonePort
extends TileEntityReactorPartBase
implements ITickableMultiblockPart {
    protected CircuitType circuitType = CircuitType.DISABLED;
    protected int outputLevel;
    protected boolean activeOnPulse;
    protected boolean greaterThan;
    protected int ticksSinceLastUpdate = 0;
    protected boolean isExternallyPowered = false;
    private boolean _isLit = false;

    public boolean canOpenGui(World world, BlockPos posistion, IBlockState state) {
        return true;
    }

    protected boolean isRedstoneActive() {
        if (!this.isConnected()) {
            return false;
        }
        MultiblockReactor reactor = this.getReactorController();
        switch (this.circuitType) {
            case outputFuelTemperature: {
                return this.checkVariable((int)reactor.getFuelHeat());
            }
            case outputCasingTemperature: {
                return this.checkVariable((int)reactor.getReactorHeat());
            }
            case outputFuelMix: {
                return this.checkVariable((int)(reactor.getFuelRichness() * 100.0f));
            }
            case outputFuelAmount: {
                return this.checkVariable(reactor.getFuelAmount());
            }
            case outputWasteAmount: {
                return this.checkVariable(reactor.getWasteAmount());
            }
            case outputEnergyAmount: {
                return this.checkVariable(reactor.getEnergyStoredPercentage());
            }
            case DISABLED: {
                return false;
            }
        }
        return this.isExternallyPowered;
    }

    public boolean isInput() {
        return this.circuitType.isInput();
    }

    public boolean isOutput() {
        return this.circuitType.isOutput();
    }

    protected boolean checkVariable(int value) {
        if (this.greaterThan) {
            return value > this.getOutputLevel();
        }
        return value < this.getOutputLevel();
    }

    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!this.isConnected()) {
            return;
        }
        if (this.isInput()) {
            boolean nowPowered;
            EnumFacing out = this.getOutwardFacing();
            boolean bl = nowPowered = null != out && this.isReceivingRedstonePowerFrom(this.func_145831_w(), this.getWorldPosition().func_177972_a(out), out);
            if (this.isExternallyPowered != nowPowered) {
                this.isExternallyPowered = nowPowered;
                this.onRedstoneInputUpdated();
                this.func_70296_d();
                this.updateRedstoneStateAndNotify();
            }
        } else {
            this.isExternallyPowered = false;
        }
    }

    protected void onRedstoneInputUpdated() {
        if (!this.isConnected()) {
            return;
        }
        MultiblockReactor reactor = this.getReactorController();
        switch (this.circuitType) {
            case inputActive: {
                if (this.isInputActiveOnPulse()) {
                    if (!this.isExternallyPowered) break;
                    reactor.setActive(!reactor.getActive());
                    break;
                }
                reactor.setActive(this.isExternallyPowered);
                break;
            }
            case inputSetControlRod: {
                if (this.isInputActiveOnPulse()) {
                    if (!this.isExternallyPowered) break;
                    if (this.shouldSetControlRodsInsteadOfChange()) {
                        reactor.setAllControlRodInsertionValues(this.outputLevel);
                        break;
                    }
                    reactor.changeAllControlRodInsertionValues((short)this.outputLevel);
                    break;
                }
                if (this.isExternallyPowered) {
                    reactor.setAllControlRodInsertionValues(this.getControlRodLevelWhileOn());
                    break;
                }
                reactor.setAllControlRodInsertionValues(this.getControlRodLevelWhileOff());
                break;
            }
            case inputEjectWaste: {
                if (!this.isExternallyPowered) break;
                reactor.ejectWaste(false, null);
                break;
            }
        }
    }

    public int getOutputLevel() {
        return this.outputLevel;
    }

    public int getControlRodLevelWhileOff() {
        return (this.outputLevel & 0xFF00) >> 8 & 0xFF;
    }

    public int getControlRodLevelWhileOn() {
        return this.outputLevel & 0xFF;
    }

    public static int packControlRodLevels(byte off, byte on) {
        return off << 8 & 0xFF00 | on & 0xFF;
    }

    public static int unpackControlRodLevelOn(int level) {
        return level & 0xFF;
    }

    public static int unpackControlRodLevelOff(int level) {
        return (level & 0xFF00) >> 8 & 0xFF;
    }

    public boolean isInputActiveOnPulse() {
        return this.activeOnPulse;
    }

    public void onReceiveUpdatePacket(int newType, int outputLevel, boolean greaterThan, boolean activeOnPulse) {
        World world = this.func_145831_w();
        BlockPos position = this.getWorldPosition();
        this.circuitType = CircuitType.values()[newType];
        this.outputLevel = outputLevel;
        this.greaterThan = greaterThan;
        this.activeOnPulse = activeOnPulse;
        this.updateLitState();
        if (TileEntityReactorRedstonePort.isAlwaysActiveOnPulse(this.circuitType)) {
            this.activeOnPulse = true;
        } else if (this.circuitType.isOutput()) {
            this.activeOnPulse = false;
        }
        if (this.isInput()) {
            EnumFacing out = this.getOutwardFacing();
            boolean bl = this.isExternallyPowered = null != out && this.isReceivingRedstonePowerFrom(world, position.func_177972_a(out), out);
            if (!this.isInputActiveOnPulse()) {
                this.onRedstoneInputUpdated();
            }
        } else {
            this.isExternallyPowered = false;
        }
        this.nofityTileEntityUpdate();
        EnumFacing outward = this.getOutwardFacing();
        if (null != outward) {
            world.func_180496_d(this.getWorldPosition().func_177972_a(outward), (Block)BrBlocks.reactorRedstonePort);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getGreaterThan() {
        return this.greaterThan;
    }

    public CircuitType getCircuitType() {
        return this.circuitType;
    }

    private boolean shouldSetControlRodsInsteadOfChange() {
        return !this.greaterThan;
    }

    private boolean isReceivingRedstonePowerFrom(World world, BlockPos position, EnumFacing facing) {
        return world.func_175687_A(position) > 0 || world.func_175651_c(position, facing) > 0;
    }

    @Override
    public void onMultiblockServerTick() {
        if (!this.isConnected() || this.ticksSinceLastUpdate++ < BigReactors.CONFIG.ticksPerRedstoneUpdate) {
            return;
        }
        this.updateRedstoneStateAndNotify();
        this.ticksSinceLastUpdate = 0;
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (data.func_74764_b("circuitType")) {
            TileEntityReactorRedstonePort tileEntityReactorRedstonePort = this;
            this.circuitType = tileEntityReactorRedstonePort.circuitType.values()[data.func_74762_e("circuitType")];
        }
        if (data.func_74764_b("outputLevel")) {
            this.outputLevel = data.func_74762_e("outputLevel");
        }
        if (data.func_74764_b("greaterThan")) {
            this.greaterThan = data.func_74767_n("greaterThan");
        }
        if (data.func_74764_b("activeOnPulse")) {
            this.activeOnPulse = data.func_74767_n("activeOnPulse");
        }
        if (data.func_74764_b("lit")) {
            this._isLit = data.func_74767_n("lit");
        }
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this.updateRedstoneStateAndNotify();
        } else {
            WorldHelper.notifyBlockUpdate((World)this.func_145831_w(), (BlockPos)this.getWorldPosition(), null, null);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.func_74768_a("circuitType", this.circuitType.ordinal());
        data.func_74768_a("outputLevel", this.outputLevel);
        data.func_74757_a("greaterThan", this.greaterThan);
        data.func_74757_a("activeOnPulse", this.activeOnPulse);
        data.func_74757_a("lit", this._isLit);
    }

    @Override
    public boolean isGoodForFrame(IMultiblockValidator validatorCallback) {
        BlockPos position = this.func_174877_v();
        validatorCallback.setLastError("multiblock.validation.reactor.redstoneport_invalid_on_frame", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
        return false;
    }

    @Override
    public boolean isGoodForSides(IMultiblockValidator validatorCallback) {
        return true;
    }

    @Override
    public boolean isGoodForTop(IMultiblockValidator validatorCallback) {
        return true;
    }

    @Override
    public boolean isGoodForBottom(IMultiblockValidator validatorCallback) {
        return true;
    }

    @Override
    public boolean isGoodForInterior(IMultiblockValidator validatorCallback) {
        BlockPos position = this.func_174877_v();
        validatorCallback.setLastError("multiblock.validation.reactor.redstoneport_invalid_on_interior", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
        return false;
    }

    public void onPostMachineAssembled(MultiblockControllerBase controller) {
        super.onPostMachineAssembled(controller);
        this.updateRedstoneStateAndNotify();
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.updateRedstoneStateAndNotify();
    }

    @Override
    public void onMachineActivated() {
        this.updateRedstoneStateAndNotify();
    }

    @Override
    public void onMachineDeactivated() {
        this.updateRedstoneStateAndNotify();
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return new ContainerBasic();
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return new GuiReactorRedstonePort(new ContainerBasic(), this);
    }

    public static boolean isAlwaysActiveOnPulse(CircuitType circuitType) {
        return circuitType == CircuitType.inputEjectWaste;
    }

    public int getWeakPower() {
        return this.isOutput() && this.isRedstoneActive() ? 15 : 0;
    }

    public boolean isLit() {
        return this._isLit;
    }

    protected boolean updateLitState() {
        this._isLit = this.isOutput() && this.isRedstoneActive() || this.isExternallyPowered;
        return this._isLit;
    }

    private void updateRedstoneStateAndNotify() {
        boolean oldLitState;
        World world = this.func_145831_w();
        if (null != world && WorldHelper.calledByLogicalServer((World)world) && (oldLitState = this._isLit) != this.updateLitState()) {
            this.nofityTileEntityUpdate();
            EnumFacing outward = this.getOutwardFacing();
            if (null != outward) {
                world.func_180496_d(this.getWorldPosition().func_177972_a(outward), (Block)BrBlocks.reactorRedstonePort);
            }
        }
    }
}

