/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.gui.BeefGuiControlBase;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class BeefGuiInsertionProgressBar
extends BeefGuiControlBase
implements IBeefTooltipControl {
    public static final int controlWidth = 20;
    public static final int controlHeight = 64;
    protected ResourceLocation controlResource;
    private double backgroundLeftU = 0.0;
    private double backgroundRightU = 0.5;
    private double rodLeftU = 0.51;
    private double rodRightU = 1.0;
    protected float barAbsoluteMaxHeight;
    protected float insertion = 0.0f;
    protected String[] tooltip = new String[]{TextFormatting.AQUA + "Control Rod", "", "Insertion: XX%"};
    private static ResourceLocation s_texture;

    public BeefGuiInsertionProgressBar(BeefGuiBase container, int x, int y) {
        super(container, x, y, 20, 64);
        this.controlResource = this.getBackgroundTexture();
        this.barAbsoluteMaxHeight = this.height - 1;
    }

    public void setInsertion(float insertion) {
        this.insertion = Math.min(1.0f, Math.max(0.0f, insertion));
    }

    protected ResourceLocation getBackgroundTexture() {
        if (null == s_texture) {
            s_texture = BigReactors.createGuiResourceLocation("controls/controlrod.png");
        }
        return s_texture;
    }

    @Override
    public void drawBackground(TextureManager renderEngine, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderEngine.func_110577_a(this.controlResource);
        vertexBuffer.func_181668_a(7, vertexBuffer.func_178973_g());
        vertexBuffer.func_181662_b((double)this.absoluteX, (double)(this.absoluteY + this.height), 0.0).func_187315_a(this.backgroundLeftU, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height), 0.0).func_187315_a(this.backgroundRightU, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(this.absoluteX + this.width), (double)this.absoluteY, 0.0).func_187315_a(this.backgroundRightU, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)this.absoluteX, (double)this.absoluteY, 0.0).func_187315_a(this.backgroundLeftU, 0.0).func_181675_d();
        tessellator.func_78381_a();
        if (this.insertion > 0.0f) {
            int barHeight = Math.max(1, (int)Math.floor(this.insertion * this.barAbsoluteMaxHeight));
            int rodMaxY = this.absoluteY + barHeight;
            float rodTopV = 1.0f - this.insertion;
            vertexBuffer.func_181668_a(7, vertexBuffer.func_178973_g());
            vertexBuffer.func_181662_b((double)this.absoluteX, (double)rodMaxY, 2.0).func_187315_a(this.rodLeftU, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(this.absoluteX + this.width), (double)rodMaxY, 2.0).func_187315_a(this.rodRightU, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(this.absoluteX + this.width), (double)this.absoluteY, 2.0).func_187315_a(this.rodRightU, (double)rodTopV).func_181675_d();
            vertexBuffer.func_181662_b((double)this.absoluteX, (double)this.absoluteY, 2.0).func_187315_a(this.rodLeftU, (double)rodTopV).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public void drawForeground(TextureManager renderEngine, int mouseX, int mouseY) {
    }

    @Override
    public String[] getTooltip() {
        this.tooltip[2] = String.format("Insertion: %.0f%%", Float.valueOf(this.insertion * 100.0f));
        return this.tooltip;
    }
}

