/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.event;

import de.ellpeck.actuallyadditions.mod.achievement.InitAchievements;
import de.ellpeck.actuallyadditions.mod.achievement.TheAchievements;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CommonEvents {
    public CommonEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DungeonLoot());
    }

    public static void checkAchievements(ItemStack gotten, EntityPlayer player, InitAchievements.Type type) {
        if (gotten != null && player != null) {
            for (TheAchievements ach : TheAchievements.values()) {
                if (ach.type != type || !ItemUtil.contains(ach.itemsToBeGotten, gotten, true)) continue;
                ach.get(player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDropEvent(LivingDropsEvent event) {
        if (event.getEntityLiving().field_70170_p != null && !event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer && ConfigBoolValues.DO_SPIDER_DROPS.isEnabled() && event.getEntityLiving() instanceof EntitySpider && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(20) <= event.getLootingLevel() * 2) {
            event.getDrops().add(new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack(Blocks.field_150321_G, event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2 + event.getLootingLevel()) + 1)));
        }
    }

    @SubscribeEvent
    public void onLogInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PacketHandlerHelper.sendPlayerDataPacket((EntityPlayer)player, true, true);
            ModUtil.LOGGER.info("Sending Player Data to player " + player.func_70005_c_() + " with UUID " + player.func_110124_au() + ".");
        }
    }

    @SubscribeEvent
    public void onCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        PlayerData.PlayerSave save;
        String name;
        CommonEvents.checkAchievements(event.crafting, event.player, InitAchievements.Type.CRAFTING);
        if (ConfigBoolValues.GIVE_BOOKLET_ON_FIRST_CRAFT.isEnabled() && !event.player.field_70170_p.field_72995_K && StackUtil.isValid(event.crafting) && event.crafting.func_77973_b() != InitItems.itemBooklet && (name = event.crafting.func_77973_b().getRegistryName().toString()) != null && name.toLowerCase(Locale.ROOT).contains("actuallyadditions") && (save = PlayerData.getDataFromPlayer(event.player)) != null && !save.bookGottenAlready) {
            save.bookGottenAlready = true;
            EntityItem entityItem = new EntityItem(event.player.field_70170_p, event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v, new ItemStack(InitItems.itemBooklet));
            entityItem.func_174867_a(0);
            event.player.field_70170_p.func_72838_d((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void onSmeltedEvent(PlayerEvent.ItemSmeltedEvent event) {
        CommonEvents.checkAchievements(event.smelting, event.player, InitAchievements.Type.SMELTING);
    }

    @SubscribeEvent
    public void onPickupEvent(EntityItemPickupEvent event) {
        CommonEvents.checkAchievements(event.getItem().func_92059_d(), event.getEntityPlayer(), InitAchievements.Type.PICK_UP);
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        WorldData.load(event.getWorld());
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        WorldData.unload(event.getWorld());
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        WorldData.save(event.getWorld());
    }
}

