/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiInputter;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FilterSettingsGui
extends Gui {
    private final FilterSettings theSettings;
    public GuiInputter.SmallerButton whitelistButton;
    public GuiInputter.SmallerButton metaButton;
    public GuiInputter.SmallerButton nbtButton;
    public GuiInputter.SmallerButton modButton;
    public GuiInputter.SmallerButton oredictButton;

    public FilterSettingsGui(FilterSettings settings, int x, int y, List<GuiButton> buttonList) {
        this.theSettings = settings;
        this.whitelistButton = new GuiInputter.SmallerButton(this.theSettings.whitelistButtonId, x, y, "", true);
        buttonList.add(this.whitelistButton);
        this.metaButton = new GuiInputter.SmallerButton(this.theSettings.metaButtonId, x, y += 14, "", true);
        buttonList.add(this.metaButton);
        this.nbtButton = new GuiInputter.SmallerButton(this.theSettings.nbtButtonId, x, y += 14, "", true);
        buttonList.add(this.nbtButton);
        this.oredictButton = new GuiInputter.SmallerButton(this.theSettings.oredictButtonId, x, y += 14, "", true);
        buttonList.add(this.oredictButton);
        this.modButton = new GuiInputter.SmallerButton(this.theSettings.modButtonId, x, y += 15, "", true);
        buttonList.add(this.modButton);
        this.update();
    }

    public void update() {
        this.whitelistButton.field_146126_j = (this.theSettings.isWhitelist ? TextFormatting.DARK_GREEN : TextFormatting.RED) + "WH";
        this.metaButton.field_146126_j = (this.theSettings.respectMeta ? TextFormatting.DARK_GREEN : TextFormatting.RED) + "ME";
        this.nbtButton.field_146126_j = (this.theSettings.respectNBT ? TextFormatting.DARK_GREEN : TextFormatting.RED) + "NB";
        this.modButton.field_146126_j = (this.theSettings.respectMod ? TextFormatting.DARK_GREEN : TextFormatting.RED) + "MO";
        this.oredictButton.field_146126_j = (this.theSettings.respectOredict == 0 ? TextFormatting.RED : (this.theSettings.respectOredict == 1 ? TextFormatting.GREEN : TextFormatting.DARK_GREEN)) + "OR";
    }

    public void drawHover(int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.whitelistButton.func_146115_a()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.BOLD + (this.theSettings.isWhitelist ? StringUtil.localize("info.actuallyadditions.gui.whitelist") : StringUtil.localize("info.actuallyadditions.gui.blacklist")));
            list.addAll(mc.field_71466_p.func_78271_c(StringUtil.localizeFormatted("info.actuallyadditions.gui.whitelistInfo", new Object[0]), 200));
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        } else if (this.metaButton.func_146115_a()) {
            GuiUtils.drawHoveringText(Collections.singletonList(TextFormatting.BOLD + (this.theSettings.respectMeta ? "Respecting" : "Ignoring") + " Metadata"), (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        } else if (this.nbtButton.func_146115_a()) {
            GuiUtils.drawHoveringText(Collections.singletonList(TextFormatting.BOLD + (this.theSettings.respectNBT ? "Respecting" : "Ignoring") + " NBT"), (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        } else if (this.modButton.func_146115_a()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.BOLD + "Mod Mode " + (this.theSettings.respectMod ? "On" : "Off"));
            list.addAll(mc.field_71466_p.func_78271_c("If this is enabled, the filter will compare the mods items come from " + TextFormatting.RED + "instead of comparing the items themselves" + TextFormatting.RESET + ". This can be useful for storage systems with mod-based chests. \nCan also be combined with the other options, but that normally isn't very useful.", 200));
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        } else if (this.oredictButton.func_146115_a()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(TextFormatting.BOLD + (this.theSettings.respectOredict == 0 ? "Ignoring" : (this.theSettings.respectOredict == 1 ? "Soft Respecting" : "Hard Respecting")) + " OreDictionary");
            String type = null;
            if (this.theSettings.respectOredict == 1) {
                type = "only one";
            } else if (this.theSettings.respectOredict == 2) {
                type = "all";
            }
            if (type != null) {
                list.addAll(mc.field_71466_p.func_78271_c("The item being passed only has to contain " + TextFormatting.DARK_GREEN + type + TextFormatting.RESET + " of the OreDictionary tags of the item in the filter.", 200));
            }
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        }
    }
}

