/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.items.ItemDrill;
import de.ellpeck.actuallyadditions.mod.items.ItemFilter;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class FilterSettings {
    public final int whitelistButtonId;
    public final int metaButtonId;
    public final int nbtButtonId;
    public final int oredictButtonId;
    public final int modButtonId;
    public final int startSlot;
    public final int endSlot;
    public boolean isWhitelist;
    public boolean respectMeta;
    public boolean respectNBT;
    public boolean respectMod;
    public int respectOredict;
    private boolean lastWhitelist;
    private boolean lastRespectMeta;
    private boolean lastRespectNBT;
    private boolean lastRespectMod;
    private int lastRecpectOredict;

    public FilterSettings(int startSlot, int endSlot, boolean defaultWhitelist, boolean defaultRespectMeta, boolean defaultRespectNBT, boolean defaultRespectMod, int defaultRespectOredict, int buttonIdStart) {
        this.startSlot = startSlot;
        this.endSlot = endSlot;
        this.isWhitelist = defaultWhitelist;
        this.respectMeta = defaultRespectMeta;
        this.respectNBT = defaultRespectNBT;
        this.respectMod = defaultRespectMod;
        this.respectOredict = defaultRespectOredict;
        this.whitelistButtonId = buttonIdStart;
        this.metaButtonId = buttonIdStart + 1;
        this.nbtButtonId = buttonIdStart + 2;
        this.oredictButtonId = buttonIdStart + 3;
        this.modButtonId = buttonIdStart + 4;
    }

    public static boolean check(ItemStack stack, ItemStack[] slots, int startSlot, int endSlot, boolean whitelist, boolean meta, boolean nbt, boolean mod, int oredict) {
        if (StackUtil.isValid(stack)) {
            for (int i = startSlot; i < endSlot; ++i) {
                if (!StackUtil.isValid(slots[i])) continue;
                if (slots[i].func_77973_b() instanceof ItemFilter) {
                    ItemStack[] filterSlots = new ItemStack[24];
                    ItemDrill.loadSlotsFromNBT(filterSlots, slots[i]);
                    if (filterSlots == null || filterSlots.length <= 0) continue;
                    for (ItemStack filterSlot : filterSlots) {
                        if (!StackUtil.isValid(filterSlot) || !FilterSettings.areEqualEnough(filterSlot, stack, meta, nbt, mod, oredict)) continue;
                        return whitelist;
                    }
                    continue;
                }
                if (!FilterSettings.areEqualEnough(slots[i], stack, meta, nbt, mod, oredict)) continue;
                return whitelist;
            }
        }
        return !whitelist;
    }

    private static boolean areEqualEnough(ItemStack first, ItemStack second, boolean meta, boolean nbt, boolean mod, int oredict) {
        boolean nbtFine;
        Item firstItem = first.func_77973_b();
        Item secondItem = second.func_77973_b();
        if (mod) {
            ResourceLocation firstReg = firstItem.getRegistryName();
            ResourceLocation secondReg = secondItem.getRegistryName();
            if (firstReg != null && secondReg != null) {
                String firstDomain = firstReg.func_110624_b();
                String secondDomain = secondReg.func_110624_b();
                if (firstDomain != null && secondDomain != null && !firstDomain.equals(secondDomain)) {
                    return false;
                }
            }
        } else if (firstItem != secondItem) {
            return false;
        }
        boolean metaFine = !meta || first.func_77952_i() == second.func_77952_i();
        boolean bl = nbtFine = !nbt || ItemStack.func_77970_a((ItemStack)first, (ItemStack)second);
        if (metaFine && nbtFine) {
            if (oredict == 0) {
                return true;
            }
            int[] firstIds = OreDictionary.getOreIDs((ItemStack)first);
            int[] secondIds = OreDictionary.getOreIDs((ItemStack)second);
            boolean firstEmpty = ArrayUtils.isEmpty((int[])firstIds);
            boolean secondEmpty = ArrayUtils.isEmpty((int[])secondIds);
            if (firstEmpty && secondEmpty) {
                return true;
            }
            if (firstEmpty || secondEmpty) {
                return false;
            }
            for (int id : firstIds) {
                if (ArrayUtils.contains((int[])secondIds, (int)id)) {
                    if (oredict != 1) continue;
                    return true;
                }
                if (oredict != 2) continue;
                return false;
            }
            return oredict == 2;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound tag, String name) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("Whitelist", this.isWhitelist);
        compound.func_74757_a("Meta", this.respectMeta);
        compound.func_74757_a("NBT", this.respectNBT);
        compound.func_74757_a("Mod", this.respectMod);
        compound.func_74768_a("Oredict", this.respectOredict);
        tag.func_74782_a(name, (NBTBase)compound);
    }

    public void readFromNBT(NBTTagCompound tag, String name) {
        NBTTagCompound compound = tag.func_74775_l(name);
        this.isWhitelist = compound.func_74767_n("Whitelist");
        this.respectMeta = compound.func_74767_n("Meta");
        this.respectNBT = compound.func_74767_n("NBT");
        this.respectMod = compound.func_74767_n("Mod");
        this.respectOredict = compound.func_74762_e("Oredict");
    }

    public boolean needsUpdateSend() {
        return this.lastWhitelist != this.isWhitelist || this.lastRespectMeta != this.respectMeta || this.lastRespectNBT != this.respectNBT || this.lastRespectMod != this.respectMod || this.lastRecpectOredict != this.respectOredict;
    }

    public void updateLasts() {
        this.lastWhitelist = this.isWhitelist;
        this.lastRespectMeta = this.respectMeta;
        this.lastRespectNBT = this.respectNBT;
        this.lastRespectMod = this.respectMod;
        this.lastRecpectOredict = this.respectOredict;
    }

    public void onButtonPressed(int id) {
        if (id == this.whitelistButtonId) {
            this.isWhitelist = !this.isWhitelist;
        } else if (id == this.metaButtonId) {
            this.respectMeta = !this.respectMeta;
        } else if (id == this.nbtButtonId) {
            this.respectNBT = !this.respectNBT;
        } else if (id == this.modButtonId) {
            boolean bl = this.respectMod = !this.respectMod;
            if (this.respectMod) {
                this.respectMeta = false;
                this.respectNBT = false;
                this.respectOredict = 0;
            }
        } else if (id == this.oredictButtonId) {
            this.respectOredict = this.respectOredict + 1 > 2 ? 0 : ++this.respectOredict;
        }
    }

    public boolean check(ItemStack stack, ItemStack[] slots) {
        return FilterSettings.check(stack, slots, this.startSlot, this.endSlot, this.isWhitelist, this.respectMeta, this.respectNBT, this.respectMod, this.respectOredict);
    }
}

