/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerFluidMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFermentingBarrel
extends TileEntityBase
implements ISharingFluidHandler {
    private static final int PROCESS_TIME = 100;
    public final FluidTank canolaTank = new FluidTank(2000){

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == InitFluids.fluidCanolaOil;
        }
    };
    public final FluidTank oilTank = new FluidTank(2000){

        public boolean canFill() {
            return false;
        }
    };
    public int currentProcessTime;
    private int lastCanola;
    private int lastOil;
    private int lastProcessTime;
    private int lastCompare;

    public TileEntityFermentingBarrel() {
        super("fermentingBarrel");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        compound.func_74768_a("ProcessTime", this.currentProcessTime);
        this.canolaTank.writeToNBT(compound);
        NBTTagCompound tag = new NBTTagCompound();
        this.oilTank.writeToNBT(tag);
        compound.func_74782_a("OilTank", (NBTBase)tag);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        this.currentProcessTime = compound.func_74762_e("ProcessTime");
        this.canolaTank.readFromNBT(compound);
        NBTTagCompound tag = compound.func_74775_l("OilTank");
        if (tag != null) {
            this.oilTank.readFromNBT(tag);
        }
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            int compare;
            int produce = 80;
            if (this.canolaTank.getFluidAmount() >= produce && produce <= this.oilTank.getCapacity() - this.oilTank.getFluidAmount()) {
                ++this.currentProcessTime;
                if (this.currentProcessTime >= 100) {
                    this.currentProcessTime = 0;
                    this.oilTank.fillInternal(new FluidStack(InitFluids.fluidOil, produce), true);
                    this.canolaTank.drainInternal(produce, true);
                }
            } else {
                this.currentProcessTime = 0;
            }
            if ((compare = this.getComparatorStrength()) != this.lastCompare) {
                this.lastCompare = compare;
                this.func_70296_d();
            }
            if ((this.canolaTank.getFluidAmount() != this.lastCanola || this.oilTank.getFluidAmount() != this.lastOil || this.currentProcessTime != this.lastProcessTime) && this.sendUpdateWithInterval()) {
                this.lastProcessTime = this.currentProcessTime;
                this.lastCanola = this.canolaTank.getFluidAmount();
                this.lastOil = this.oilTank.getFluidAmount();
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.oilTank.getFluidAmount() / (float)this.oilTank.getCapacity() * 15.0f;
        return (int)calc;
    }

    @SideOnly(value=Side.CLIENT)
    public int getProcessScaled(int i) {
        return this.currentProcessTime * i / 100;
    }

    @SideOnly(value=Side.CLIENT)
    public int getOilTankScaled(int i) {
        return this.oilTank.getFluidAmount() * i / this.oilTank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getCanolaTankScaled(int i) {
        return this.canolaTank.getFluidAmount() * i / this.canolaTank.getCapacity();
    }

    @Override
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        FluidHandlerFluidMap map = new FluidHandlerFluidMap();
        if (facing != EnumFacing.DOWN) {
            map.addHandler(InitFluids.fluidCanolaOil, (IFluidHandler)this.canolaTank);
        }
        if (facing != EnumFacing.UP) {
            map.addHandler(InitFluids.fluidOil, (IFluidHandler)this.oilTank);
        }
        return map;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? 0 : handler.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canFillFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canDrainFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler instanceof IFluidTank) {
            return new FluidTankInfo[]{((IFluidTank)handler).getInfo()};
        }
        return null;
    }

    @Override
    public int getFluidAmountToSplitShare() {
        return this.oilTank.getFluidAmount();
    }

    @Override
    public boolean doesShareFluid() {
        return true;
    }

    @Override
    public EnumFacing[] getFluidShareSides() {
        return EnumFacing.values();
    }
}

