/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewer;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityInputter
extends TileEntityInventoryBase
implements IButtonReactor,
INumberReactor {
    public static final int PUT_FILTER_START = 13;
    public static final int PULL_FILTER_START = 1;
    public static final int OKAY_BUTTON_ID = 133;
    public int sideToPut = -1;
    public int slotToPutStart;
    public int slotToPutEnd;
    public TileEntity placeToPut;
    public int sideToPull = -1;
    public int slotToPullStart;
    public int slotToPullEnd;
    public TileEntity placeToPull;
    public boolean isAdvanced;
    public FilterSettings leftFilter = new FilterSettings(1, 13, true, true, false, false, 0, -1000);
    public FilterSettings rightFilter = new FilterSettings(13, 25, true, true, false, false, 0, -2000);
    private int lastPutSide;
    private int lastPutStart;
    private int lastPutEnd;
    private int lastPullSide;
    private int lastPullStart;
    private int lastPullEnd;

    public TileEntityInputter(int slots, String name) {
        super(slots, name);
    }

    public TileEntityInputter() {
        super(1, "inputter");
        this.isAdvanced = false;
    }

    @Override
    public void onNumberReceived(int text, int textID, EntityPlayer player) {
        if (text != -1) {
            if (textID == 0) {
                this.slotToPutStart = Math.max(text, 0);
            }
            if (textID == 1) {
                this.slotToPutEnd = Math.max(text, 0);
            }
            if (textID == 2) {
                this.slotToPullStart = Math.max(text, 0);
            }
            if (textID == 3) {
                this.slotToPullEnd = Math.max(text, 0);
            }
        }
        this.func_70296_d();
    }

    private boolean newPulling() {
        for (EnumFacing side : EnumFacing.values()) {
            IItemHandler cap;
            if (this.placeToPull.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && (cap = (IItemHandler)this.placeToPull.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) != null) {
                for (int i = Math.max(this.slotToPullStart, 0); i < Math.min(this.slotToPullEnd, cap.getSlots()); ++i) {
                    if (!this.checkBothFilters(cap.getStackInSlot(i), false) || !WorldUtil.doItemInteraction(i, 0, this.placeToPull, this, side, null)) continue;
                    return true;
                }
            }
            if (this.placeToPull instanceof TileEntityItemViewer) break;
        }
        return false;
    }

    private boolean newPutting() {
        if (this.checkBothFilters(this.slots[0], true)) {
            for (EnumFacing side : EnumFacing.values()) {
                IItemHandler cap;
                if (this.placeToPut.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && (cap = (IItemHandler)this.placeToPut.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) != null) {
                    for (int i = Math.max(this.slotToPutStart, 0); i < Math.min(this.slotToPutEnd, cap.getSlots()); ++i) {
                        if (!WorldUtil.doItemInteraction(0, i, this, this.placeToPut, null, side)) continue;
                        return true;
                    }
                }
                if (this.placeToPut instanceof TileEntityItemViewer) break;
            }
        }
        return false;
    }

    private boolean checkBothFilters(ItemStack stack, boolean output) {
        return !this.isAdvanced || (output ? this.rightFilter : this.leftFilter).check(stack, this.slots);
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        IItemHandler cap;
        EnumFacing side;
        BlockPos offset;
        this.placeToPull = null;
        this.placeToPut = null;
        if (this.sideToPull != -1 && this.field_145850_b.func_175667_e(offset = this.field_174879_c.func_177972_a(side = WorldUtil.getDirectionBySidesInOrder(this.sideToPull)))) {
            this.placeToPull = this.field_145850_b.func_175625_s(offset);
            if (this.slotToPullEnd <= 0 && this.placeToPull != null && this.placeToPull.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (cap = (IItemHandler)this.placeToPull.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                this.slotToPullEnd = cap.getSlots();
            }
        }
        if (this.sideToPut != -1 && this.field_145850_b.func_175667_e(offset = this.field_174879_c.func_177972_a(side = WorldUtil.getDirectionBySidesInOrder(this.sideToPut)))) {
            this.placeToPut = this.field_145850_b.func_175625_s(offset);
            if (this.slotToPutEnd <= 0 && this.placeToPut != null && this.placeToPut.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (cap = (IItemHandler)this.placeToPut.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                this.slotToPutEnd = cap.getSlots();
            }
        }
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        this.leftFilter.onButtonPressed(buttonID);
        this.rightFilter.onButtonPressed(buttonID);
        if (buttonID == 0 || buttonID == 1) {
            this.slotToPutStart = 0;
            this.slotToPutEnd = 0;
        }
        if (buttonID == 2 || buttonID == 3) {
            this.slotToPullStart = 0;
            this.slotToPullEnd = 0;
        }
        if (buttonID == 0) {
            ++this.sideToPut;
        }
        if (buttonID == 1) {
            --this.sideToPut;
        }
        if (buttonID == 2) {
            ++this.sideToPull;
        }
        if (buttonID == 3) {
            --this.sideToPull;
        }
        if (this.sideToPut >= 6) {
            this.sideToPut = -1;
        } else if (this.sideToPut < -1) {
            this.sideToPut = 5;
        } else if (this.sideToPull >= 6) {
            this.sideToPull = -1;
        } else if (this.sideToPull < -1) {
            this.sideToPull = 5;
        }
        this.func_70296_d();
        this.saveDataOnChangeOrWorldStart();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("SideToPut", this.sideToPut);
            compound.func_74768_a("SlotToPut", this.slotToPutStart);
            compound.func_74768_a("SlotToPutEnd", this.slotToPutEnd);
            compound.func_74768_a("SideToPull", this.sideToPull);
            compound.func_74768_a("SlotToPull", this.slotToPullStart);
            compound.func_74768_a("SlotToPullEnd", this.slotToPullEnd);
            this.leftFilter.writeToNBT(compound, "LeftFilter");
            this.rightFilter.writeToNBT(compound, "RightFilter");
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.sideToPut = compound.func_74762_e("SideToPut");
            this.slotToPutStart = compound.func_74762_e("SlotToPut");
            this.slotToPutEnd = compound.func_74762_e("SlotToPutEnd");
            this.sideToPull = compound.func_74762_e("SideToPull");
            this.slotToPullStart = compound.func_74762_e("SlotToPull");
            this.slotToPullEnd = compound.func_74762_e("SlotToPullEnd");
            this.leftFilter.readFromNBT(compound, "LeftFilter");
            this.rightFilter.readFromNBT(compound, "RightFilter");
        }
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!(this.isRedstonePowered || this.ticksElapsed % 30 != 0 || this.sideToPull == this.sideToPut && this.slotToPullStart == this.slotToPutStart && this.slotToPullEnd == this.slotToPutEnd)) {
                if (!StackUtil.isValid(this.slots[0]) && this.sideToPull != -1 && this.placeToPull != null) {
                    this.newPulling();
                }
                if (StackUtil.isValid(this.slots[0]) && this.sideToPut != -1 && this.placeToPut != null) {
                    this.newPutting();
                }
            }
            if ((this.sideToPut != this.lastPutSide || this.sideToPull != this.lastPullSide || this.slotToPullStart != this.lastPullStart || this.slotToPullEnd != this.lastPullEnd || this.slotToPutStart != this.lastPutStart || this.slotToPutEnd != this.lastPutEnd || this.leftFilter.needsUpdateSend() || this.rightFilter.needsUpdateSend()) && this.sendUpdateWithInterval()) {
                this.lastPutSide = this.sideToPut;
                this.lastPullSide = this.sideToPull;
                this.lastPullStart = this.slotToPullStart;
                this.lastPullEnd = this.slotToPullEnd;
                this.lastPutStart = this.slotToPutStart;
                this.lastPutEnd = this.slotToPutEnd;
                this.leftFilter.updateLasts();
                this.rightFilter.updateLasts();
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 0;
    }
}

