/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.misc.ConnectionPair;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import io.netty.util.internal.ConcurrentSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityLaserRelay
extends TileEntityBase {
    public static final int MAX_DISTANCE = 15;
    public final LaserType type;
    private Network cachedNetwork;
    private int changeAmountAtCaching = -1;
    private Set<IConnectionPair> tempConnectionStorage;

    public TileEntityLaserRelay(String name, LaserType type) {
        super(name);
        this.type = type;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SYNC) {
            ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(this.field_174879_c, this.field_145850_b);
            NBTTagList list = compound.func_150295_c("Connections", 10);
            if (!list.func_82582_d()) {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ConnectionPair pair = new ConnectionPair();
                    pair.readFromNBT(list.func_150305_b(i));
                    ActuallyAdditionsAPI.connectionHandler.addConnection(pair.getPositions()[0], pair.getPositions()[1], this.type, this.field_145850_b, pair.doesSuppressRender());
                }
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SYNC) {
            NBTTagList list = new NBTTagList();
            ConcurrentSet<IConnectionPair> connections = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.field_174879_c, this.field_145850_b);
            if (connections != null && !connections.isEmpty()) {
                for (IConnectionPair pair : connections) {
                    NBTTagCompound tag = new NBTTagCompound();
                    pair.writeToNBT(tag);
                    list.func_74742_a((NBTBase)tag);
                }
            }
            compound.func_74782_a("Connections", (NBTBase)list);
        }
    }

    public Network getNetwork() {
        if (this.cachedNetwork == null || this.cachedNetwork.changeAmount != this.changeAmountAtCaching) {
            this.cachedNetwork = ActuallyAdditionsAPI.connectionHandler.getNetworkFor(this.field_174879_c, this.field_145850_b);
            this.changeAmountAtCaching = this.cachedNetwork != null ? this.cachedNetwork.changeAmount : -1;
        }
        return this.cachedNetwork;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.tempConnectionStorage = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.field_174879_c, this.field_145850_b);
        ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(this.field_174879_c, this.field_145850_b);
    }

    public void func_145829_t() {
        if (this.tempConnectionStorage != null) {
            for (IConnectionPair pair : this.tempConnectionStorage) {
                ActuallyAdditionsAPI.connectionHandler.addConnection(pair.getPositions()[0], pair.getPositions()[1], pair.getType(), this.field_145850_b, pair.doesSuppressRender());
            }
            this.tempConnectionStorage = null;
        }
        super.func_145829_t();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract String getExtraDisplayString();

    @SideOnly(value=Side.CLIENT)
    public abstract String getCompassDisplayString();

    public abstract void onCompassAction(EntityPlayer var1);
}

