/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLaserRelayItem
extends TileEntityLaserRelay {
    public final Map<BlockPos, IItemHandler> handlersAround = new ConcurrentHashMap<BlockPos, IItemHandler>();
    public int priority;

    public TileEntityLaserRelayItem(String name) {
        super(name, LaserType.ITEM);
    }

    public TileEntityLaserRelayItem() {
        this("laserRelayItem");
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isWhitelisted(ItemStack stack, boolean output) {
        return true;
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<BlockPos, IItemHandler> old = new HashMap<BlockPos, IItemHandler>(this.handlersAround);
        boolean change = false;
        this.handlersAround.clear();
        for (int i = 0; i <= 5; ++i) {
            IItemHandler handler;
            EnumFacing side = WorldUtil.getDirectionBySidesInOrder(i);
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (tile == null || tile instanceof TileEntityItemViewer || tile instanceof TileEntityLaserRelay || (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) == null) continue;
            this.handlersAround.put(pos, handler);
            IItemHandler oldHandler = (IItemHandler)old.get(pos);
            if (oldHandler != null && handler.equals(oldHandler)) continue;
            change = true;
        }
        if ((change || old.size() != this.handlersAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    public void getItemHandlersInNetwork(Network network, List<TileEntityItemViewer.GenericItemHandlerInfo> storeList) {
        ArrayList<BlockPos> alreadyChecked = new ArrayList<BlockPos>();
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.field_145850_b.func_175667_e(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                TileEntity aRelayTile = this.field_145850_b.func_175625_s(relay);
                if (!(aRelayTile instanceof TileEntityLaserRelayItem)) continue;
                TileEntityLaserRelayItem relayTile = (TileEntityLaserRelayItem)aRelayTile;
                TileEntityItemViewer.GenericItemHandlerInfo info = new TileEntityItemViewer.GenericItemHandlerInfo(relayTile);
                for (Map.Entry<BlockPos, IItemHandler> handler : relayTile.handlersAround.entrySet()) {
                    if (alreadyChecked.contains(handler.getKey())) continue;
                    alreadyChecked.add(handler.getKey());
                    info.handlers.add(handler.getValue());
                }
                storeList.add(info);
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Priority", this.priority);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getExtraDisplayString() {
        return "Priority: " + TextFormatting.DARK_RED + this.getPriority() + TextFormatting.RESET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCompassDisplayString() {
        return TextFormatting.GREEN + "Right-Click to increase! \nSneak-Right-Click to decrease!";
    }

    @Override
    public void onCompassAction(EntityPlayer player) {
        this.priority = player.func_70093_af() ? --this.priority : ++this.priority;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.priority = compound.func_74762_e("Priority");
        }
    }
}

