/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityOilGenerator
extends TileEntityBase
implements ISharingEnergyProvider,
ISharingFluidHandler {
    private static final int BURN_TIME = 100;
    public final EnergyStorage storage = new EnergyStorage(50000);
    public final FluidTank tank = new FluidTank(2000){

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack stack) {
            Fluid fluid = stack.getFluid();
            return fluid != null && ActuallyAdditionsAPI.OIL_GENERATOR_RECIPES.containsKey(fluid.getName());
        }
    };
    public int currentEnergyProduce;
    public int currentBurnTime;
    private int lastEnergy;
    private int lastTank;
    private int lastBurnTime;
    private int lastEnergyProduce;
    private int lastCompare;

    public TileEntityOilGenerator() {
        super("oilGenerator");
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurningScaled(int i) {
        return this.currentBurnTime * i / 100;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("BurnTime", this.currentBurnTime);
            compound.func_74768_a("CurrentEnergy", this.currentEnergyProduce);
        }
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentBurnTime = compound.func_74762_e("BurnTime");
            this.currentEnergyProduce = compound.func_74762_e("CurrentEnergy");
        }
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag;
            boolean bl = flag = this.currentBurnTime > 0;
            if (this.currentBurnTime > 0 && this.currentEnergyProduce > 0) {
                --this.currentBurnTime;
                this.storage.receiveEnergy(this.currentEnergyProduce, false);
            } else if (!this.isRedstonePowered) {
                this.currentEnergyProduce = this.getEnergyForCurrentFluid();
                int fuelUsed = 50;
                if (this.storage.getEnergyStored() < this.storage.getMaxEnergyStored() && this.tank.getFluidAmount() >= fuelUsed) {
                    this.currentBurnTime = 100;
                    this.tank.drainInternal(fuelUsed, true);
                } else {
                    this.currentBurnTime = 0;
                }
            }
            if (flag != this.currentBurnTime > 0 || this.lastCompare != this.getComparatorStrength()) {
                this.lastCompare = this.getComparatorStrength();
                this.func_70296_d();
            }
            if ((this.storage.getEnergyStored() != this.lastEnergy || this.tank.getFluidAmount() != this.lastTank || this.lastBurnTime != this.currentBurnTime || this.lastEnergyProduce != this.currentEnergyProduce) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastTank = this.tank.getFluidAmount();
                this.lastBurnTime = this.currentBurnTime;
                this.lastEnergyProduce = this.currentEnergyProduce;
            }
        }
    }

    private int getEnergyForCurrentFluid() {
        Fluid fluid;
        FluidStack stack = this.tank.getFluid();
        if (stack != null && (fluid = stack.getFluid()) != null) {
            return ActuallyAdditionsAPI.OIL_GENERATOR_RECIPES.get(fluid.getName());
        }
        return 0;
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 15.0f;
        return (int)calc;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return facing != EnumFacing.DOWN ? this.tank : null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? 0 : handler.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canFillFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canDrainFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler instanceof IFluidTank) {
            return new FluidTankInfo[]{((IFluidTank)handler).getInfo()};
        }
        return null;
    }

    @Override
    public int getFluidAmountToSplitShare() {
        return 0;
    }

    @Override
    public boolean doesShareFluid() {
        return false;
    }

    @Override
    public EnumFacing[] getFluidShareSides() {
        return null;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public EnumFacing[] getEnergyShareSides() {
        return EnumFacing.values();
    }
}

