/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.cable;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import zmaster587.advancedRocketry.cable.CableNetwork;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.util.UniversalBattery;

public class EnergyNetwork
extends CableNetwork
implements IUniversalEnergy {
    UniversalBattery battery = new UniversalBattery(500);

    public static EnergyNetwork initNetwork() {
        Random random = new Random(System.currentTimeMillis());
        int id = random.nextInt();
        while (usedIds.contains(id)) {
            id = random.nextInt();
        }
        EnergyNetwork net = new EnergyNetwork();
        usedIds.add(id);
        net.networkID = id;
        return net;
    }

    @Override
    public boolean merge(CableNetwork cableNetwork) {
        if (super.merge(cableNetwork)) {
            this.battery.acceptEnergy(((EnergyNetwork)cableNetwork).battery.getEnergyStored(), false);
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        IEnergyStorage dataHandlerSink;
        int amountToMove;
        IEnergyStorage dataHandlerSink2;
        Map.Entry obj;
        int amount = 1000;
        if (this.sinks.isEmpty() || this.sources.isEmpty() && this.battery.getEnergyStored() == 0) {
            return;
        }
        int demand = 0;
        int supply = this.battery.getEnergyStored();
        Iterator sinkItr = this.sinks.iterator();
        Iterator sourceItr = this.sources.iterator();
        while (sinkItr.hasNext()) {
            obj = (Map.Entry)sinkItr.next();
            dataHandlerSink2 = (IEnergyStorage)((TileEntity)obj.getKey()).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)obj.getValue());
            demand += dataHandlerSink2.receiveEnergy(amount, true);
        }
        while (sourceItr.hasNext()) {
            obj = (Map.Entry)sourceItr.next();
            dataHandlerSink2 = (IEnergyStorage)((TileEntity)obj.getKey()).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)obj.getValue());
            supply += dataHandlerSink2.extractEnergy(amount, true);
        }
        int amountMoved = amountToMove = Math.min(supply, demand);
        for (Map.Entry obj2 : this.sinks) {
            dataHandlerSink = (IEnergyStorage)((TileEntity)obj2.getKey()).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)obj2.getValue());
            amountToMove -= dataHandlerSink.receiveEnergy(amountToMove, false);
        }
        amountMoved -= this.battery.extractEnergy(amountMoved, false);
        for (Map.Entry obj2 : this.sources) {
            dataHandlerSink = (IEnergyStorage)((TileEntity)obj2.getKey()).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)obj2.getValue());
            amountMoved -= dataHandlerSink.extractEnergy(amountMoved, false);
        }
    }

    public void setEnergyStored(int amt) {
    }

    public int extractEnergy(int amt, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public int acceptEnergy(int amt, boolean simulate) {
        return this.battery.acceptEnergy(amt, simulate);
    }

    public void setMaxEnergyStored(int max) {
    }

    public boolean canReceive() {
        return false;
    }

    public boolean canExtract() {
        return false;
    }
}

