/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.mission.MissionGasCollection;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class EntityStationDeployedRocket
extends EntityRocket {
    public EnumFacing launchDirection;
    public EnumFacing forwardDirection;
    public HashedBlockPosition launchLocation;
    private ModuleText atmText;
    private short gasId;
    boolean coastMode;
    private ForgeChunkManager.Ticket ticket;

    public EntityStationDeployedRocket(World world) {
        super(world);
        this.launchDirection = EnumFacing.DOWN;
        this.launchLocation = new HashedBlockPosition(0, 0, 0);
        this.atmText = new ModuleText(182, 114, "", 0x2D2D2D);
        this.gasId = 0;
        this.ticket = null;
    }

    public EntityStationDeployedRocket(World world, StorageChunk storage, StatsRocket stats, double x, double y, double z) {
        super(world, storage, stats, x, y, z);
        this.launchLocation = new HashedBlockPosition((int)x, (int)y, (int)z);
        this.launchDirection = EnumFacing.DOWN;
        stats.setSeatLocation(-1, -1, -1);
        this.atmText = new ModuleText(182, 114, "", 0x2D2D2D);
        this.gasId = 0;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
    }

    @Override
    public void launch() {
        ISpaceObject spaceObj;
        if (this.isInFlight()) {
            return;
        }
        if (this.isInOrbit()) {
            this.setInFlight(true);
            return;
        }
        if (this.getFuelAmount() < this.getFuelCapacity()) {
            return;
        }
        if (this.field_70170_p.field_73011_w.getDimension() == Configuration.spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_180425_c())) != null && ((DimensionProperties)spaceObj.getProperties().getParentProperties()).isGasGiant()) {
            this.setInFlight(true);
            this.launchLocation.x = (int)Math.floor(this.field_70165_t);
            this.launchLocation.y = (short)this.field_70163_u;
            this.launchLocation.z = (int)Math.floor(this.field_70161_v);
            Iterator connectedTiles = this.connectedInfrastructure.iterator();
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
            while (connectedTiles.hasNext()) {
                IInfrastructure i = (IInfrastructure)connectedTiles.next();
                if (!i.disconnectOnLiftOff()) continue;
                this.disconnectInfrastructure(i);
                connectedTiles.remove();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void func_70071_h_() {
        block19: {
            block21: {
                block20: {
                    this.lastWorldTickTicked = this.field_70170_p.func_82737_E();
                    if (!this.isInFlight()) break block19;
                    burningFuel = this.isBurningFuel();
                    if (this.launchLocation == null || this.storage == null) {
                        return;
                    }
                    if (!this.field_70170_p.field_72995_K && this.ticket == null) {
                        this.ticket = ForgeChunkManager.requestTicket((Object)AdvancedRocketry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
                        if (this.ticket != null) {
                            this.ticket.bindEntity((Entity)this);
                            for (i = 0; i < 9; ++i) {
                                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)new ChunkPos(this.forwardDirection.func_82601_c() * i + (this.launchLocation.x >> 4), this.forwardDirection.func_82599_e() * i + (this.launchLocation.z >> 4)));
                            }
                        }
                    }
                    v0 = isCoasting = Math.abs(this.field_70165_t - (double)this.launchLocation.x) < (double)(4 * this.storage.getSizeX()) && Math.abs(this.field_70163_u - (double)this.launchLocation.y) < (double)(4 * this.storage.getSizeY()) && Math.abs(this.field_70161_v - (double)this.launchLocation.z) < (double)(4 * this.storage.getSizeZ());
                    if (!isCoasting && this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74362_aa < 2) {
                        for (Vector3F<Float> vec : this.stats.getEngineLocations()) {
                            xMult = Math.abs(this.forwardDirection.func_82601_c());
                            zMult = Math.abs(this.forwardDirection.func_82599_e());
                            for (i = 0; i < 4; ++i) {
                                xVel = (1.0f - xMult) * ((this.field_70146_Z.nextFloat() - 0.5f) / 8.0f) + xMult * -0.15f;
                                zVel = (1.0f - zMult) * ((this.field_70146_Z.nextFloat() - 0.5f) / 8.0f) + zMult * -0.15f;
                                AdvancedRocketry.proxy.spawnParticle("rocketFlame", this.field_70170_p, this.field_70165_t + (double)((Float)vec.x).floatValue() + this.field_70159_w, this.field_70163_u + (double)((Float)vec.y).floatValue(), this.field_70161_v + (double)((Float)vec.z).floatValue(), xVel, (this.field_70146_Z.nextFloat() - 0.5f) / 8.0f, (double)zVel + this.field_70179_y);
                            }
                        }
                    }
                    if (this.forwardDirection == null) {
                        return;
                    }
                    if (!this.isInOrbit()) break block20;
                    v1 = this.field_70165_t - (double)this.launchLocation.x;
                    v2 = this.storage.getSizeX() % 2 == 0 ? 0.0f : 0.5f;
                    if (!(Math.abs(v1 - (double)v2) < 0.01)) ** GOTO lbl-1000
                    v3 = this.field_70161_v - (double)this.launchLocation.z;
                    v4 = this.storage.getSizeZ() % 2 == 0 ? 0.0f : 0.5f;
                    if (Math.abs(v3 - (double)v4) < 0.01) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = isCoasting = false;
                    }
                    if (isCoasting) {
                        dir = this.launchDirection.func_176734_d();
                        speed = 0.075f;
                        this.field_70159_w = speed * (float)dir.func_82601_c();
                        this.field_70181_x = speed * (float)dir.func_96559_d();
                        this.field_70179_y = speed * (float)dir.func_82599_e();
                    } else {
                        dir = this.forwardDirection.func_176734_d();
                        acc = 0.01f;
                        this.field_70159_w = (double)acc * ((double)this.launchLocation.x - this.field_70165_t + (double)(this.storage.getSizeX() % 2 == 0 ? 0.0f : 0.5f)) + 0.01 * (double)dir.func_82601_c();
                        this.field_70181_x = 0.0;
                        this.field_70179_y = (double)acc * ((double)this.launchLocation.z - this.field_70161_v + (double)(this.storage.getSizeZ() % 2 == 0 ? 0.0f : 0.5f)) + 0.01 * (double)dir.func_82599_e();
                    }
                    if (this.field_70163_u > (double)this.launchLocation.y) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.setInFlight(false);
                            this.setInOrbit(false);
                            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLandedEvent(this));
                            if (this.ticket != null) {
                                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
                                this.ticket = null;
                            }
                        }
                        this.field_70181_x = 0.0;
                        this.func_70107_b((float)this.launchLocation.x + (this.storage.getSizeX() % 2 == 0 ? 0.0f : 0.5f), this.launchLocation.y, (float)this.launchLocation.z + (this.storage.getSizeZ() % 2 == 0 ? 0.0f : 0.5f));
                    }
                    break block21;
                }
                if (isCoasting) {
                    speed = 0.01f;
                    this.field_70159_w = (double)(speed * (float)this.launchDirection.func_82601_c()) * (2.1 * (double)this.storage.getSizeX() - Math.abs((double)(2 * this.storage.getSizeX()) - Math.abs(this.field_70165_t - (double)this.launchLocation.x)) + 0.05);
                    this.field_70181_x = (double)(speed * (float)this.launchDirection.func_96559_d()) * (2.1 * (double)this.storage.getSizeY() - Math.abs((double)(2 * this.storage.getSizeY()) - Math.abs(this.field_70163_u - (double)this.launchLocation.y)) + 0.05);
                    this.field_70179_y = (double)(speed * (float)this.launchDirection.func_82599_e()) * (2.1 * (double)this.storage.getSizeZ() - Math.abs((double)(2 * this.storage.getSizeZ()) - Math.abs(this.field_70161_v - (double)this.launchLocation.z)) + 0.05);
                } else {
                    acc = 0.01f;
                    this.field_70159_w += (double)(acc * (float)this.forwardDirection.func_82601_c());
                    this.field_70181_x += (double)(acc * (float)this.forwardDirection.func_96559_d());
                    this.field_70179_y += (double)(acc * (float)this.forwardDirection.func_82599_e());
                }
                if (!this.field_70170_p.field_72995_K && this.func_70011_f(this.launchLocation.x, this.launchLocation.y, this.launchLocation.z) > 128.0) {
                    if (this.ticket != null) {
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
                        this.ticket = null;
                    }
                    this.onOrbitReached();
                    return;
                }
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        DimensionProperties props;
        List<ModuleBase> modules = super.getModules(ID, player);
        Iterator<ModuleBase> itr = modules.iterator();
        while (itr.hasNext()) {
            ModuleBase module = itr.next();
            if (!(module instanceof ModuleButton) || !((ModuleButton)module).getText().equalsIgnoreCase("Select Dst")) continue;
            itr.remove();
            break;
        }
        if ((props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c())).isGasGiant()) {
            try {
                this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getLocalizedName(new FluidStack(props.getHarvestableGasses().get(this.gasId), 1)));
            }
            catch (IndexOutOfBoundsException e) {
                this.gasId = 0;
                this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getLocalizedName(new FluidStack(props.getHarvestableGasses().get(this.gasId), 1)));
            }
        } else {
            this.atmText.setText(LibVulpes.proxy.getLocalizedString("msg.entityDeployedRocket.notGasGiant"));
        }
        modules.add((ModuleBase)new ModuleButton(170, 114, 1, "", (IButtonInventory)this, TextureResources.buttonLeft, 5, 8));
        modules.add((ModuleBase)this.atmText);
        modules.add((ModuleBase)new ModuleButton(240, 114, 2, "", (IButtonInventory)this, TextureResources.buttonRight, 5, 8));
        return modules;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.DECONSTRUCT.ordinal()));
                break;
            }
            case 1: {
                DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
                if (!props.isGasGiant()) break;
                this.gasId = (short)(this.gasId + 1);
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()));
                break;
            }
            case 2: {
                DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
                if (!props.isGasGiant()) break;
                this.gasId = (short)(this.gasId - 1);
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()));
                break;
            }
            default: {
                super.onInventoryButtonPressed(buttonId);
            }
        }
    }

    @Override
    public void onOrbitReached() {
        if (this.field_70128_L) {
            return;
        }
        ISpaceObject spaceObj = null;
        this.setInOrbit(true);
        if (this.field_70170_p.field_73011_w.getDimension() != Configuration.spaceDimId || (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_180425_c())) == null || !((DimensionProperties)spaceObj.getProperties().getParentProperties()).isGasGiant()) {
            this.setInOrbit(true);
            return;
        }
        this.func_70107_b((double)this.forwardDirection.func_82601_c() * 64.0 + (double)this.launchLocation.x + (this.storage.getSizeX() % 2 == 0 ? 0.0 : 0.5), this.field_70163_u, (double)this.forwardDirection.func_82599_e() * 64.0 + (double)this.launchLocation.z + (this.storage.getSizeZ() % 2 == 0 ? 0.0 : 0.5));
        float intakePower = ((Integer)this.stats.getStatTag("intakePower")).intValue();
        MissionGasCollection miningMission = new MissionGasCollection(intakePower == 0.0f ? 360L : (long)(2.0f * ((float)((Integer)this.stats.getStatTag("liquidCapacity")).intValue() / intakePower)), this, this.connectedInfrastructure, AtmosphereRegister.getInstance().getHarvestableGasses().get(this.gasId));
        DimensionProperties properties = (DimensionProperties)spaceObj.getProperties().getParentProperties();
        miningMission.setDimensionId(properties.getId());
        properties.addSatallite(miningMission);
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(miningMission));
        }
        for (IInfrastructure i : this.connectedInfrastructure) {
            i.linkMission(miningMission);
        }
        this.func_70106_y();
    }

    @Override
    protected void writeNetworkableNBT(NBTTagCompound nbt) {
        super.writeNetworkableNBT(nbt);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            out.writeShort((int)this.gasId);
        } else {
            super.writeDataToNetwork(out, id);
        }
    }

    @Override
    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            nbt.func_74777_a("gas", in.readShort());
        } else {
            super.readDataFromNetwork(in, packetId, nbt);
        }
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == EntityRocket.PacketType.MENU_CHANGE.ordinal()) {
            DimensionProperties props = DimensionManager.getEffectiveDimId(this.field_70170_p, this.func_180425_c());
            if (props.isGasGiant()) {
                this.gasId = nbt.func_74765_d("gas");
                if (this.gasId < 0) {
                    this.gasId = (short)(props.getHarvestableGasses().size() - 1);
                } else if (this.gasId > props.getHarvestableGasses().size() - 1) {
                    this.gasId = 0;
                }
                if (!this.field_70170_p.field_72995_K) {
                    PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this, (byte)EntityRocket.PacketType.MENU_CHANGE.ordinal()), (int)this.field_70170_p.field_73011_w.getDimension(), (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (double)64.0);
                } else {
                    this.atmText.setText(props.getHarvestableGasses().get(this.gasId).getLocalizedName(new FluidStack(AtmosphereRegister.getInstance().getHarvestableGasses().get(this.gasId), 1)));
                }
            }
        } else {
            super.useNetworkData(player, side, id, nbt);
        }
    }

    @Override
    public void writeMissionPersistantNBT(NBTTagCompound nbt) {
        super.writeMissionPersistantNBT(nbt);
        nbt.func_74768_a("fwd", this.forwardDirection.ordinal());
        nbt.func_74768_a("launchX", this.launchLocation.x);
        nbt.func_74768_a("launchY", (int)this.launchLocation.y);
        nbt.func_74768_a("launchZ", this.launchLocation.z);
        nbt.func_74777_a("gas", this.gasId);
    }

    @Override
    public void readMissionPersistantNBT(NBTTagCompound nbt) {
        super.readMissionPersistantNBT(nbt);
        this.forwardDirection = EnumFacing.values()[nbt.func_74762_e("fwd")];
        this.launchLocation.x = nbt.func_74762_e("launchX");
        this.launchLocation.y = (short)nbt.func_74762_e("launchY");
        this.launchLocation.z = nbt.func_74762_e("launchZ");
        this.gasId = nbt.func_74765_d("gas");
    }
}

