/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemIdWithName;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.ZUtils;

public class ItemSatellite
extends ItemIdWithName {
    @Deprecated
    public SatelliteProperties getSatellite(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            SatelliteProperties satellite = new SatelliteProperties();
            satellite.readFromNBT(nbt);
            return satellite;
        }
        return null;
    }

    public SatelliteProperties getSatelliteProperties(ItemStack stackIn) {
        if (stackIn.func_77942_o()) {
            int powerStorage = 0;
            int powerGeneration = 0;
            int maxData = 0;
            EmbeddedInventory inv = this.readInvFromNBT(stackIn);
            if (inv.func_70301_a(0) == null) {
                return null;
            }
            String satType = SatelliteRegistry.getSatelliteProperty(inv.func_70301_a(0)).getSatelliteType();
            SatelliteBase sat = SatelliteRegistry.getSatallite(satType);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null) continue;
                SatelliteProperties properties = SatelliteRegistry.getSatelliteProperty(stack);
                if (!sat.acceptsItemInConstruction(stack)) continue;
                powerStorage += properties.getPowerStorage();
                powerGeneration += properties.getPowerGeneration();
                maxData += properties.getMaxDataStorage();
            }
            return new SatelliteProperties(powerGeneration, powerStorage, satType, maxData);
        }
        return null;
    }

    public EmbeddedInventory readInvFromNBT(ItemStack stackIn) {
        EmbeddedInventory inv = new EmbeddedInventory(7);
        if (!stackIn.func_77942_o() || !stackIn.func_77978_p().func_74764_b("inv")) {
            return inv;
        }
        inv.readFromNBT(stackIn.func_77978_p().func_74775_l("inv"));
        return inv;
    }

    public void writeInvToNBT(ItemStack stackIn, EmbeddedInventory inv) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (!stackIn.func_77942_o()) {
            stackIn.func_77982_d(nbt);
        } else {
            nbt = stackIn.func_77978_p();
        }
        NBTTagCompound tag = new NBTTagCompound();
        inv.writeToNBT(tag);
        nbt.func_74782_a("inv", (NBTBase)tag);
    }

    public void setSatellite(ItemStack stack, SatelliteProperties satellite) {
        SatelliteBase satellite2 = SatelliteRegistry.getSatallite(satellite.getSatelliteType());
        if (satellite2 != null) {
            NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            SatelliteProperties internalProps = this.getSatelliteProperties(stack);
            if (internalProps != null) {
                satellite.setMaxData(internalProps.getMaxDataStorage());
                satellite.setPowerGeneration(internalProps.getPowerGeneration());
                satellite.setPowerStorage(internalProps.getMaxDataStorage());
            }
            satellite.writeToNBT(nbt);
            stack.func_77982_d(nbt);
            this.setName(stack, satellite2.getName());
        } else {
            stack.func_77982_d(null);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        SatelliteProperties properties = this.getSatellite(stack);
        if (properties != null) {
            list.add(this.getName(stack));
            list.add("ID: " + properties.getId());
            if (SatelliteProperties.Property.BATTERY.isOfType(properties.getPropertyFlag())) {
                int powerStorage = properties.getPowerStorage();
                if (powerStorage > 0) {
                    list.add("Power Storage: " + powerStorage);
                } else {
                    list.add(ChatFormatting.RED + "No Power Storage");
                }
            }
            if (SatelliteProperties.Property.POWER_GEN.isOfType(properties.getPropertyFlag())) {
                int powerGeneration = properties.getPowerGeneration();
                if (powerGeneration > 0) {
                    list.add("Power Generation: " + powerGeneration);
                } else {
                    list.add(ChatFormatting.RED + "No Power Generation!");
                }
            }
            if (SatelliteProperties.Property.DATA.isOfType(properties.getPropertyFlag())) {
                int dataStorage = properties.getMaxDataStorage();
                if (dataStorage > 0) {
                    list.add("Data Storage: " + ZUtils.formatNumber((int)dataStorage));
                } else {
                    list.add(ChatFormatting.YELLOW + "No Data Storage!");
                }
            }
        } else {
            list.add(ChatFormatting.RED + "Empty Chassis");
        }
    }
}

