/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.item.ItemIdWithName;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.util.Vector3F;

public class ItemStationChip
extends ItemIdWithName {
    private static final String uuidIdentifier = "UUID";

    public ItemStationChip() {
        this.func_77627_a(true);
    }

    public void setTakeoffCoords(ItemStack stack, Vector3F<Float> pos, int dimid) {
        this.setTakeoffCoords(stack, ((Float)pos.x).floatValue(), ((Float)pos.y).floatValue(), ((Float)pos.z).floatValue(), dimid);
    }

    public void setTakeoffCoords(ItemStack stack, float x, float y, float z, int dimid) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbtEntry = nbt.func_74764_b("dimid" + dimid) ? nbt.func_74775_l("dimid" + dimid) : new NBTTagCompound();
        nbtEntry.func_74776_a("x", x);
        nbtEntry.func_74776_a("y", y);
        nbtEntry.func_74776_a("z", z);
        nbt.func_74782_a("dimid" + dimid, (NBTBase)nbtEntry);
        stack.func_77982_d(nbt);
    }

    public Vector3F<Float> getTakeoffCoords(ItemStack stack, int dimid) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimid" + dimid)) {
            nbt = nbt.func_74775_l("dimid" + dimid);
            return new Vector3F((Object)Float.valueOf(nbt.func_74760_g("x")), (Object)Float.valueOf(nbt.func_74760_g("y")), (Object)Float.valueOf(nbt.func_74760_g("z")));
        }
        return null;
    }

    public static int getUUID(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(uuidIdentifier);
        }
        return 0;
    }

    public static void setUUID(ItemStack stack, int uuid) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a(uuidIdentifier, uuid);
        stack.func_77982_d(nbt);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (ItemStationChip.getUUID(stack) == 0) {
            list.add(ChatFormatting.GRAY + "Unprogrammed");
        } else {
            ISpaceObject obj;
            list.add(ChatFormatting.GREEN + "Station " + ItemStationChip.getUUID(stack));
            super.func_77624_a(stack, player, list, bool);
            if (player.field_70170_p.field_73011_w.getDimension() == Configuration.spaceDimId && (obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(player.func_180425_c())) != null) {
                Vector3F<Float> vec = this.getTakeoffCoords(stack, obj.getOrbitingPlanetId());
                if (vec != null) {
                    list.add("X: " + vec.x);
                    list.add("Z: " + vec.z);
                } else {
                    list.add("X: N/A");
                    list.add("Z: N/A");
                }
            }
        }
    }
}

