/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item.components;

import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.client.ResourceIcon;
import zmaster587.libVulpes.items.ItemIngredient;

public class ItemPressureTank
extends ItemIngredient
implements IArmorComponent,
IFluidContainerItem {
    ResourceIcon icon;
    int capacity;

    public ItemPressureTank(int number, int capacity) {
        super(number);
        this.capacity = capacity;
        this.field_77777_bU = 1;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        if (stack.func_77978_p() == null) {
            list.add("Empty");
        } else {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
            list.add(fluidStack.getLocalizedName() + ": " + fluidStack.amount);
        }
    }

    public void onTick(World world, EntityPlayer player, ItemStack armorStack, IInventory inv, ItemStack componentStack) {
    }

    public boolean onComponentAdded(World world, ItemStack armorStack) {
        return true;
    }

    public void onComponentRemoved(World world, ItemStack armorStack) {
    }

    public void onArmorDamaged(EntityLivingBase entity, ItemStack armorStack, ItemStack componentStack, DamageSource source, int damage) {
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77942_o()) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p());
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        return this.capacity * (int)Math.pow(2.0, container.func_77952_i());
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        FluidStack stack;
        if (container.func_77942_o() && (stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p())) != null) {
            if (stack.isFluidEqual(resource)) {
                int amtToAdd = Math.min(resource.amount, this.getCapacity(container) - stack.amount);
                if (doFill) {
                    stack.amount += amtToAdd;
                    stack.writeToNBT(container.func_77978_p());
                }
                return amtToAdd;
            }
            return 0;
        }
        int amtToAdd = Math.min(resource.amount, this.getCapacity(container));
        if (doFill) {
            NBTTagCompound nbt = new NBTTagCompound();
            FluidStack stack2 = new FluidStack(resource, amtToAdd);
            stack2.writeToNBT(nbt);
            container.func_77982_d(nbt);
        }
        return amtToAdd;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_77942_o()) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p());
            if (stack == null) {
                return null;
            }
            int amountDrain = Math.min(maxDrain, stack.amount);
            if (doDrain) {
                if (amountDrain == stack.amount) {
                    container.func_77982_d(null);
                } else {
                    stack.amount -= amountDrain;
                    stack.writeToNBT(container.func_77978_p());
                }
            }
            return new FluidStack(stack, amountDrain);
        }
        return null;
    }

    public ResourceIcon getComponentIcon(ItemStack armorStack) {
        return null;
    }

    public boolean isAllowedInSlot(ItemStack stack, EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.CHEST;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderScreen(ItemStack componentStack, List<ItemStack> modules, RenderGameOverlayEvent event, Gui gui) {
    }
}

