/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.mission;

import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.entity.EntityStationDeployedRocket;
import zmaster587.advancedRocketry.mission.MissionResourceCollection;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class MissionGasCollection
extends MissionResourceCollection {
    Fluid gasFluid;

    public MissionGasCollection() {
    }

    public MissionGasCollection(long l, EntityRocket entityRocket, LinkedList<IInfrastructure> connectedInfrastructure, Fluid gasFluid) {
        super((long)((double)l * Configuration.gasCollectionMult), entityRocket, connectedInfrastructure);
        this.gasFluid = gasFluid;
    }

    @Override
    public String getName() {
        return LibVulpes.proxy.getLocalizedString("mission.gascollection.name");
    }

    @Override
    public void onMissionComplete() {
        if ((Integer)this.rocketStats.getStatTag("intakePower") > 0 && this.gasFluid != null) {
            int amountOfGas = Integer.MAX_VALUE;
            Fluid type = this.gasFluid;
            for (TileEntity tile : this.rocketStorage.getFluidTiles()) {
                if ((amountOfGas -= ((IFluidHandler)tile).fill(new FluidStack(type, amountOfGas), true)) == 0) break;
            }
        }
        EntityStationDeployedRocket rocket = new EntityStationDeployedRocket((World)DimensionManager.getWorld((int)this.launchDimension), this.rocketStorage, this.rocketStats, this.x, this.y, this.z);
        rocket.setFuelAmount(0);
        WorldServer world = DimensionManager.getWorld((int)this.launchDimension);
        rocket.readMissionPersistantNBT(this.missionPersistantNBT);
        EnumFacing dir = rocket.forwardDirection;
        rocket.field_98038_p = true;
        rocket.func_70107_b((double)dir.func_82601_c() * 64.0 + (double)rocket.launchLocation.x + (this.rocketStorage.getSizeX() % 2 == 0 ? 0.0 : 0.5), this.y, (double)dir.func_82599_e() * 64.0 + (double)rocket.launchLocation.z + (this.rocketStorage.getSizeZ() % 2 == 0 ? 0.0 : 0.5));
        world.func_72838_d((Entity)rocket);
        rocket.setInOrbit(true);
        rocket.setInFlight(true);
        for (HashedBlockPosition i : this.infrastructureCoords) {
            TileEntity tile = world.func_175625_s(new BlockPos(i.x, (int)i.y, i.z));
            if (!(tile instanceof IInfrastructure)) continue;
            ((IInfrastructure)tile).unlinkMission();
            rocket.linkInfrastructure((IInfrastructure)tile);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("gas", this.gasFluid.getName());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.gasFluid = FluidRegistry.getFluid((String)nbt.func_74779_i("gas"));
    }
}

