/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.libVulpes.network.BasePacket;

public class PacketStellarInfo
extends BasePacket {
    StellarBody star;
    int starId;

    public PacketStellarInfo() {
    }

    public PacketStellarInfo(int starId, StellarBody star) {
        this.star = star;
        this.starId = starId;
    }

    public void write(ByteBuf out) {
        NBTTagCompound nbt = new NBTTagCompound();
        out.writeInt(this.starId);
        out.writeBoolean(this.star == null);
        if (this.star != null) {
            this.star.writeToNBT(nbt);
            PacketBuffer packetBuffer = new PacketBuffer(out);
            packetBuffer.func_150786_a(nbt);
        }
    }

    public void readClient(ByteBuf in) {
        PacketBuffer packetBuffer = new PacketBuffer(in);
        this.starId = in.readInt();
        if (in.readBoolean()) {
            if (DimensionManager.getInstance().isDimensionCreated(this.starId)) {
                DimensionManager.getInstance().removeStar(this.starId);
            }
        } else {
            NBTTagCompound nbt;
            try {
                nbt = packetBuffer.func_150793_b();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            StellarBody star = DimensionManager.getInstance().getStar(this.starId);
            if (star != null) {
                star.readFromNBT(nbt);
            } else {
                star = new StellarBody();
                star.readFromNBT(nbt);
                DimensionManager.getInstance().addStar(star);
            }
        }
    }

    public void read(ByteBuf in) {
    }

    public void executeClient(EntityPlayer thePlayer) {
    }

    public void executeServer(EntityPlayerMP player) {
    }
}

