/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.ArrayUtils;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.modules.ModulePlanetSelector;
import zmaster587.advancedRocketry.util.ITilePlanetSystemSelectable;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.util.INetworkMachine;

public class TilePlanetSelector
extends TilePointer
implements ISelectionNotify,
IModularInventory,
IProgressBar,
INetworkMachine {
    protected ModulePlanetSelector container;
    public static final int certaintyDataValue = 5000;
    DimensionProperties dimCache;
    int[] cachedProgressValues = new int[]{-1, -1, -1};

    public void onSelectionConfirmed(Object sender) {
        TileEntity tile = this.getMasterBlock();
        if (tile instanceof ITilePlanetSystemSelectable) {
            ((ITilePlanetSystemSelectable)tile).setSelectedPlanetId(this.container.getSelectedSystem());
        }
        this.onSelected(sender);
    }

    public void onSelected(Object sender) {
        this.selectSystem(this.container.getSelectedSystem());
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    private void selectSystem(int id) {
        this.dimCache = id == -1 ? null : DimensionManager.getInstance().getDimensionProperties(this.container.getSelectedSystem());
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        this.container = new ModulePlanetSelector(0, TextureResources.starryBG, this, true);
        this.container.setOffset(1000, 1000);
        modules.add((ModuleBase)this.container);
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public float getNormallizedProgress(int id) {
        return 0.0f;
    }

    public void setProgress(int id, int progress) {
        this.cachedProgressValues[id] = progress;
    }

    public int getProgress(int id) {
        if (!this.field_145850_b.field_72995_K) {
            return 25;
        }
        return this.cachedProgressValues[id];
    }

    public int getTotalProgress(int id) {
        if (this.dimCache == null) {
            return 50;
        }
        if (id == 0) {
            return this.dimCache.getAtmosphereDensity() / 2;
        }
        if (id == 1) {
            return this.dimCache.orbitalDist / 2;
        }
        return (int)(this.dimCache.gravitationalMultiplier * 50.0f);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound comp = new NBTTagCompound();
        this.writeToNBTHelper(comp);
        this.writeAdditionalNBT(comp);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, comp);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readAdditionalNBT(pkt.func_148857_g());
    }

    public void writeAdditionalNBT(NBTTagCompound nbt) {
        if (this.getMasterBlock() != null) {
            List<Integer> list = ((ITilePlanetSystemSelectable)this.getMasterBlock()).getVisiblePlanets();
            Integer[] intList = new Integer[list.size()];
            nbt.func_74783_a("visiblePlanets", ArrayUtils.toPrimitive((Integer[])list.toArray(intList)));
        }
    }

    public void readAdditionalNBT(NBTTagCompound nbt) {
        if (this.container != null) {
            int[] intArray;
            for (int id : intArray = nbt.func_74759_k("visiblePlanets")) {
                this.container.setPlanetAsKnown(id);
            }
        }
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeInt(this.container.getSelectedSystem());
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            nbt.func_74768_a("id", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            int dimId = nbt.func_74762_e("id");
            this.container.setSelectedSystem(dimId);
            this.selectSystem(dimId);
            this.func_70296_d();
        }
    }

    public void onSystemFocusChanged(Object sender) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }
}

