/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTextBox;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileDockingPort
extends TileEntity
implements IModularInventory,
IGuiCallback,
INetworkMachine {
    ModuleTextBox myId;
    ModuleTextBox targetId;
    String targetIdStr = "";
    String myIdStr = "";

    public String getTargetId() {
        return this.targetIdStr;
    }

    public String getMyId() {
        return this.myIdStr;
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModuleText(20, 50, "Target Id", 0x2A2A2A));
        if (this.field_145850_b.field_72995_K) {
            this.myId = new ModuleTextBox((IGuiCallback)this, 20, 30, 60, 12, 9);
            this.targetId = new ModuleTextBox((IGuiCallback)this, 20, 60, 60, 12, 9);
            this.targetId.setText(this.targetIdStr);
            this.myId.setText(this.myIdStr);
            modules.add((ModuleBase)this.targetId);
            modules.add((ModuleBase)this.myId);
        }
        modules.add((ModuleBase)new ModuleText(20, 20, "My Id", 0x2A2A2A));
        return modules;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        if (this.targetId != null) {
            this.targetId.setText(this.targetIdStr);
            this.myId.setText(this.myIdStr);
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        if (this.targetId != null) {
            this.targetId.setText(this.targetIdStr);
            this.myId.setText(this.myIdStr);
        }
    }

    public void onModuleUpdated(ModuleBase module) {
        if (module == this.myId) {
            this.myIdStr = this.myId.getText();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        } else if (module == this.targetId) {
            this.targetIdStr = this.targetId.getText();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 1));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.myIdStr.isEmpty()) {
            nbt.func_74778_a("myId", this.myIdStr);
        }
        if (!this.targetIdStr.isEmpty()) {
            nbt.func_74778_a("targetId", this.targetIdStr);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.myIdStr = nbt.func_74779_i("myId");
        this.targetIdStr = nbt.func_74779_i("targetId");
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unregisterTileWithStation(this.field_145850_b, this.field_174879_c);
    }

    public void onLoad() {
        super.onLoad();
        this.registerTileWithStation(this.field_145850_b, this.field_174879_c);
    }

    public String getModularInventoryName() {
        return "tile.stationMarker.name";
    }

    public void registerTileWithStation(World world, BlockPos pos) {
        ISpaceObject spaceObj;
        if (!world.field_72995_K && world.field_73011_w.getDimension() == Configuration.spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos)) instanceof SpaceObject) {
            ((SpaceObject)spaceObj).addDockingPosition(pos, this.myIdStr);
        }
    }

    public void unregisterTileWithStation(World world, BlockPos pos) {
        ISpaceObject spaceObj;
        if (!world.field_72995_K && world.field_73011_w.getDimension() == Configuration.spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos)) instanceof SpaceObject) {
            ((SpaceObject)spaceObj).removeDockingPosition(pos);
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            PacketBuffer buff = new PacketBuffer(out);
            buff.writeInt(this.myIdStr.length());
            buff.func_180714_a(this.myIdStr);
        } else if (id == 1) {
            PacketBuffer buff = new PacketBuffer(out);
            buff.writeInt(this.targetIdStr.length());
            buff.func_180714_a(this.targetIdStr);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        int len = in.readInt();
        PacketBuffer buff = new PacketBuffer(in);
        nbt.func_74778_a("id", buff.func_150789_c(len));
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            ISpaceObject spaceObj;
            this.myIdStr = nbt.func_74779_i("id");
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73011_w.getDimension() == Configuration.spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceObject) {
                ((SpaceObject)spaceObj).addDockingPosition(this.field_174879_c, this.myIdStr);
            }
        } else if (id == 1) {
            this.targetIdStr = nbt.func_74779_i("id");
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }
}

