/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileStationAltitudeController
extends TileEntity
implements IModularInventory,
ITickable,
INetworkMachine,
ISliderBar {
    int gravity;
    int progress;
    private ModuleText moduleGrav = new ModuleText(6, 15, "Altitude: ", 0xAA2020);
    private ModuleText numGravPylons;
    private ModuleText maxGravBuildSpeed = new ModuleText(6, 25, "Max Altitude Change Rate: ", 0xAA2020);
    private ModuleText targetGrav = new ModuleText(6, 35, "Target Altitude:", 0x202020);

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.moduleGrav);
        modules.add((ModuleBase)this.maxGravBuildSpeed);
        modules.add((ModuleBase)this.targetGrav);
        modules.add((ModuleBase)new ModuleSlider(6, 60, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        this.updateText();
        return modules;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = this.func_189515_b(new NBTTagCompound());
        nbt.func_74768_a("gravity", this.gravity);
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.gravity = pkt.func_148857_g().func_74762_e("gravity");
    }

    private void updateText() {
        if (this.field_145850_b.field_72995_K) {
            ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
            if (object != null) {
                this.moduleGrav.setText(String.format("Altitude: %.0fKm", Float.valueOf(object.getOrbitalDistance() * 200.0f + 100.0f)));
                this.maxGravBuildSpeed.setText(String.format("Max Altitude Change Rate: %.1f", 7200.0 * object.getMaxRotationalAcceleration()));
            }
            this.targetGrav.setText(String.format("Target Altitude: %d", this.gravity * 200 + 100));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_73011_w instanceof WorldProviderSpace) {
            if (!this.field_145850_b.field_72995_K) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
                if (object != null) {
                    double targetGravity = this.gravity;
                    double angVel = object.getOrbitalDistance();
                    double acc = 0.1 * ((double)this.getTotalProgress(0) - angVel + 1.0) / (double)this.getTotalProgress(0);
                    double difference = targetGravity - angVel;
                    if (difference != 0.0) {
                        double finalVel = angVel;
                        if (difference < 0.0) {
                            finalVel = angVel + Math.max(difference, -acc);
                        } else if (difference > 0.0) {
                            finalVel = angVel + Math.min(difference, acc);
                        }
                        object.setOrbitalDistance((float)finalVel);
                        if (!this.field_145850_b.field_72995_K) {
                            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(object, PacketStationUpdate.Type.ALTITUDE_UPDATE));
                        } else {
                            this.updateText();
                        }
                    }
                }
            } else {
                this.updateText();
            }
        }
    }

    public String getModularInventoryName() {
        return "tile.altitudeController.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeShort(this.progress);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            this.setProgress(0, in.readShort());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("numRotations", (short)this.gravity);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.gravity = nbt.func_74765_d("numRotations");
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(0) / (float)this.getTotalProgress(0);
    }

    public void setProgress(int id, int progress) {
        this.progress = progress;
        this.gravity = progress;
    }

    public int getProgress(int id) {
        return this.progress;
    }

    public int getTotalProgress(int id) {
        return 190;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setProgressByUser(int id, int progress) {
        this.setProgress(id, progress);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }
}

