/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.ore;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import zmaster587.advancedRocketry.util.OreGenProperties;

public class CustomizableOreGen
implements IWorldGenerator {
    IBlockState oreToGen;
    int numPerChunk;
    int clumpSize;
    int heightLevel;
    int difference;

    public CustomizableOreGen(IBlockState oreToGen, int numPerChunk, int clumpSize, int minHeight, int maxHeight) {
        this.oreToGen = oreToGen;
        this.numPerChunk = numPerChunk;
        this.clumpSize = clumpSize;
        this.difference = maxHeight - minHeight;
        this.heightLevel = minHeight;
    }

    public CustomizableOreGen(OreGenProperties.OreEntry genProps) {
        this.oreToGen = genProps.getBlockState();
        this.clumpSize = genProps.getClumpSize();
        this.heightLevel = genProps.getMinHeight();
        this.difference = genProps.getMaxHeight() - this.heightLevel;
        this.numPerChunk = genProps.getChancePerChunk();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (int i = 0; i < this.numPerChunk; ++i) {
            int coordX = 16 * chunkX + random.nextInt(16);
            int coordY = this.heightLevel + random.nextInt(this.difference);
            int coordZ = 16 * chunkZ + random.nextInt(16);
            new WorldGenMinable(this.oreToGen, this.clumpSize).func_180709_b(world, random, new BlockPos(coordX, coordY, coordZ));
        }
    }
}

