/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ColorChoiceEvent;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.input.Keyboard;

public class ColorChoiceLabel
extends Label<ColorChoiceLabel> {
    private List<Integer> colorList = new ArrayList<Integer>();
    private Map<Integer, List<String>> tooltipMap = new HashMap<Integer, List<String>>();
    private Integer currentColor = null;
    private List<ColorChoiceEvent> choiceEvents = null;

    public ColorChoiceLabel(Minecraft mc, Gui gui) {
        super(mc, gui);
        this.setText("");
    }

    public ColorChoiceLabel addColors(Integer ... colors) {
        for (Integer color : colors) {
            this.colorList.add(color);
            if (this.currentColor != null) continue;
            this.currentColor = color;
            this.fireChoiceEvents(this.currentColor);
        }
        return this;
    }

    public ColorChoiceLabel setChoiceTooltip(Integer color, String ... tooltips) {
        this.tooltipMap.put(color, Arrays.asList(tooltips));
        return this;
    }

    public ColorChoiceLabel setCurrentColor(Integer color) {
        this.currentColor = color;
        return this;
    }

    public Integer getCurrentColor() {
        return this.currentColor;
    }

    @Override
    public List<String> getTooltips() {
        List<String> tooltips = this.tooltipMap.get(this.currentColor);
        if (tooltips == null) {
            return super.getTooltips();
        }
        return tooltips;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isEnabled()) {
            this.drawStyledBoxNormal(window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, 0xFF000000 | this.getCurrentColor());
            RenderHelper.drawLeftTriangle(xx + this.bounds.width - 10, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleNormal);
            RenderHelper.drawRightTriangle(xx + this.bounds.width - 4, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleNormal);
        } else {
            this.drawStyledBoxDisabled(window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            RenderHelper.drawLeftTriangle(xx + this.bounds.width - 10, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleDisabled);
            RenderHelper.drawRightTriangle(xx + this.bounds.width - 4, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleDisabled);
        }
        super.drawOffset(window, x, y, 0, 1);
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            int index = this.colorList.indexOf(this.currentColor);
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (--index < 0) {
                    index = this.colorList.size() - 1;
                }
            } else if (++index >= this.colorList.size()) {
                index = 0;
            }
            this.currentColor = this.colorList.get(index);
            this.fireChoiceEvents(this.currentColor);
        }
        return null;
    }

    public ColorChoiceLabel addChoiceEvent(ColorChoiceEvent event) {
        if (this.choiceEvents == null) {
            this.choiceEvents = new ArrayList<ColorChoiceEvent>();
        }
        this.choiceEvents.add(event);
        return this;
    }

    public void removeChoiceEvent(ColorChoiceEvent event) {
        if (this.choiceEvents != null) {
            this.choiceEvents.remove(event);
        }
    }

    private void fireChoiceEvents(Integer color) {
        if (this.choiceEvents != null) {
            for (ColorChoiceEvent event : this.choiceEvents) {
                event.choiceChanged(this, color);
            }
        }
    }
}

