/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBlockDust;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.internal.NetworkHandler;
import shetiphian.core.internal.PacketParticle;

public class ParticleHelper {
    public static IBlockState getStateForParticle(Entity entity, BlockPos pos, IBlockState state, Class blockType) {
        BlockPos pos2 = new BlockPos(pos.func_177958_n(), (int)Math.ceil(entity.field_70163_u) - 1, pos.func_177952_p());
        IBlockState state2 = entity.field_70170_p.func_180495_p(pos2);
        if (state2.func_177230_c().getClass().isInstance(blockType)) {
            pos = pos2;
            state = state2;
        }
        return ParticleHelper.getStateForParticle(state, entity.field_70170_p, pos);
    }

    public static IBlockState getStateForParticle(IBlockState state, World world, BlockPos pos) {
        return state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
    }

    public static boolean addLandingEffects(WorldServer world, BlockPos pos, EntityLivingBase entity, int numberOfParticles, int stateId) {
        if (world.field_72995_K) {
            if (pos != null) {
                NetworkHandler.sendToServer(new PacketParticle(EnumParticleTypes.BLOCK_DUST, pos, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, 0.15f, numberOfParticles, stateId));
            } else {
                world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{stateId});
            }
        }
        return true;
    }

    public static boolean addRunningEffects(World world, BlockPos pos, Entity entity, int stateId) {
        if (world.field_72995_K) {
            if (pos != null) {
                NetworkHandler.sendToServer(new PacketParticle(EnumParticleTypes.BLOCK_CRACK, pos, entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, 1.0, 0, stateId));
            } else {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{stateId});
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addHitEffects(World world, BlockPos pos, EnumFacing facing, ParticleManager effectRenderer, int particleStateId) {
        IBlockState state = world.func_180495_p(pos);
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1f;
        AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
        double d0 = (double)i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72340_a;
        double d1 = (double)j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72338_b;
        double d2 = (double)k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72339_c;
        switch (facing) {
            case DOWN: {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)f;
                break;
            }
            case UP: {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)f;
                break;
            }
            case NORTH: {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)f;
                break;
            }
            case SOUTH: {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)f;
                break;
            }
            case WEST: {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)f;
                break;
            }
            case EAST: {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)f;
            }
        }
        ParticleDigging.Factory iparticlefactory = new ParticleDigging.Factory();
        return ParticleHelper.spawnDiggingFX(effectRenderer, (IParticleFactory)iparticlefactory, world, pos, d0, d1, d2, 0.0, 0.0, 0.0, particleStateId);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer, int particleStateId) {
        ParticleDigging.Factory iparticlefactory = new ParticleDigging.Factory();
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    ParticleHelper.spawnDiggingFX(effectRenderer, (IParticleFactory)iparticlefactory, world, pos, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, particleStateId);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean spawnDiggingFX(ParticleManager effectRenderer, IParticleFactory factory, World world, BlockPos pos, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int particleStateId) {
        Particle entityFX = factory.func_178902_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, new int[]{particleStateId});
        if (entityFX instanceof ParticleDigging) {
            effectRenderer.func_78873_a((Particle)((ParticleDigging)entityFX).func_174846_a(pos));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean spawnBlockDustFX(ParticleManager effectRenderer, IParticleFactory factory, World world, BlockPos pos, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int particleStateId) {
        Particle entityFX = factory.func_178902_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, new int[]{particleStateId});
        if (entityFX instanceof ParticleBlockDust) {
            effectRenderer.func_78873_a((Particle)((ParticleBlockDust)entityFX).func_174846_a(pos));
            return true;
        }
        return false;
    }
}

