/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.network;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.network.PacketBase;

public abstract class PacketPipeline {
    private SimpleNetworkWrapper wrapper;
    private int counter;

    public void initialise(String channelName) {
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(channelName.toLowerCase());
        this.counter = 0;
        this.registerPackets();
        this.registerPackets(this.wrapper);
    }

    @Deprecated
    public void registerPackets(SimpleNetworkWrapper network) {
    }

    public void registerPackets() {
    }

    protected <REQ extends IMessage, REPLY extends IMessage> void registerPacket(Class<REQ> packet, Class<? extends IMessageHandler<REQ, REPLY>> handler, PacketSide side) {
        if (side != PacketSide.CLIENT) {
            this.wrapper.registerMessage(handler, packet, this.counter, Side.SERVER);
        }
        if (side != PacketSide.SERVER) {
            this.wrapper.registerMessage(handler, packet, this.counter, Side.CLIENT);
        }
        ++this.counter;
    }

    public static void onMessage(final PacketBase packet, MessageContext ctx) {
        switch (ctx.side) {
            case CLIENT: {
                PacketPipeline.onMessageClient(packet);
                break;
            }
            case SERVER: {
                final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        packet.handleServerSide((EntityPlayer)player);
                    }
                });
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void onMessageClient(final PacketBase packet) {
        final Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_152344_a(new Runnable(){

            @Override
            public void run() {
                packet.handleClientSide((EntityPlayer)minecraft.field_71439_g);
            }
        });
    }

    public void sendPacketToServer(PacketBase packet) {
        this.wrapper.sendToServer((IMessage)packet);
    }

    public void sendPacketToPlayer(PacketBase packet, EntityPlayerMP player) {
        this.wrapper.sendTo((IMessage)packet, player);
    }

    public void sendPacketToList(PacketBase packet, List<EntityPlayerMP> players) {
        for (EntityPlayerMP player : players) {
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToAll(PacketBase packet) {
        this.wrapper.sendToAll((IMessage)packet);
    }

    public void sendPacketToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        this.wrapper.sendToAllAround((IMessage)packet, point);
    }

    public void sendPacketToDimension(PacketBase packet, int dimensionId) {
        this.wrapper.sendToDimension((IMessage)packet, dimensionId);
    }

    protected static enum PacketSide {
        CLIENT,
        SERVER,
        BOTH;

    }
}

