/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.blay09.mods.cookingforblockheads.block.BlockMilkJar;
import net.blay09.mods.cookingforblockheads.block.BlockToaster;
import net.blay09.mods.cookingforblockheads.tile.TileMilkJar;
import net.blay09.mods.cookingforblockheads.tile.TileToaster;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WailaProvider {
    public static void register(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new MilkJarDataProvider(), BlockMilkJar.class);
        registrar.registerBodyProvider((IWailaDataProvider)new ToasterDataProvider(), BlockToaster.class);
    }

    public static class ToasterDataProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileToaster tileToaster;
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof TileToaster && (tileToaster = (TileToaster)tileEntity).isActive()) {
                list.add(I18n.func_135052_a((String)"waila.cookingforblockheads:toastProgress", (Object[])new Object[]{(int)(tileToaster.getToastProgress() * 100.0f)}) + "%");
            }
            return list;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tagCompound, World world, BlockPos pos) {
            if (tileEntity != null) {
                tileEntity.func_189515_b(tagCompound);
            }
            return tagCompound;
        }
    }

    public static class MilkJarDataProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof TileMilkJar) {
                TileMilkJar tileMilkJar = (TileMilkJar)tileEntity;
                list.add(I18n.func_135052_a((String)"waila.cookingforblockheads:milkStored", (Object[])new Object[]{(int)tileMilkJar.getMilkAmount(), (int)tileMilkJar.getMilkCapacity()}));
            }
            return list;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tagCompound, World world, BlockPos pos) {
            if (tileEntity != null) {
                tileEntity.func_189515_b(tagCompound);
            }
            return tagCompound;
        }
    }
}

