/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics;

import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.logistics.PL2ASMLoader;
import sonar.logistics.PL2Blocks;
import sonar.logistics.PL2Common;
import sonar.logistics.PL2Config;
import sonar.logistics.PL2Crafting;
import sonar.logistics.PL2Events;
import sonar.logistics.PL2Items;
import sonar.logistics.api.IInfoManager;
import sonar.logistics.api.PL2API;
import sonar.logistics.commands.CommandResetInfoRegistry;
import sonar.logistics.info.LogicInfoRegistry;
import sonar.logistics.integration.MineTweakerIntegration;
import sonar.logistics.logic.comparators.ComparatorRegistry;
import sonar.logistics.managers.CableManager;
import sonar.logistics.managers.ClientInfoManager;
import sonar.logistics.managers.DisplayManager;
import sonar.logistics.managers.NetworkManager;
import sonar.logistics.managers.ServerInfoManager;
import sonar.logistics.managers.WirelessManager;
import sonar.logistics.utils.SapphireOreGen;

@Mod(modid="practicallogistics2", name="Practical Logistics 2", dependencies="required-after:sonarcore@[3.2.7,);required-after:mcmultipart@[1.4.0,);", version="2.0.2", acceptedMinecraftVersions="[1.10.2]")
public class PL2 {
    @SidedProxy(clientSide="sonar.logistics.PL2Client", serverSide="sonar.logistics.PL2Common")
    public static PL2Common proxy;
    public static SimpleNetworkWrapper network;
    public static Logger logger;
    @Mod.Instance(value="practicallogistics2")
    public static PL2 instance;
    public NetworkManager networkManager = new NetworkManager();
    public CableManager cableManager = new CableManager();
    public DisplayManager displayManager = new DisplayManager();
    public ServerInfoManager serverManager = new ServerInfoManager();
    public ClientInfoManager clientManager = new ClientInfoManager();
    public ComparatorRegistry comparatorRegistry = new ComparatorRegistry();
    public static CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Releasing the Kraken");
        if (!Loader.isModLoaded((String)"SonarCore") && !Loader.isModLoaded((String)"sonarcore")) {
            logger.fatal("Sonar Core is not loaded");
        } else {
            logger.info("Successfully loaded with Sonar Core");
        }
        PL2API.init();
        logger.info("Initilised API");
        network = NetworkRegistry.INSTANCE.newSimpleChannel("practicallogistics2");
        logger.info("Registered Network");
        PL2Common.registerPackets();
        logger.info("Registered Packets");
        PL2Config.initConfiguration(event);
        logger.info("Loaded Configuration");
        PL2Blocks.registerBlocks();
        logger.info("Loaded Blocks");
        PL2Items.registerItems();
        logger.info("Loaded Items");
        PL2Items.registerMultiparts();
        logger.info("Loaded Multiparts");
        if (PL2Config.sapphireOre) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new SapphireOreGen(), (int)1);
            logger.info("Registered Sapphire World Generator");
        } else {
            logger.info("Sapphire Ore Generation is disabled in the config");
        }
        PL2ASMLoader.init(event);
        LogicInfoRegistry.INSTANCE.init();
        this.comparatorRegistry.register();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        logger.info("Breaking into the pentagon");
        PL2Crafting.addRecipes();
        logger.info("Registered Crafting Recipes");
        OreDictionary.registerOre((String)"oreSapphire", (Block)PL2Blocks.sapphire_ore);
        OreDictionary.registerOre((String)"gemSapphire", (Item)PL2Items.sapphire);
        OreDictionary.registerOre((String)"dustSapphire", (Item)PL2Items.sapphire_dust);
        logger.info("Registered OreDict");
        MinecraftForge.EVENT_BUS.register((Object)new PL2Events());
        logger.info("Registered Events");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new PL2Common());
        logger.info("Registered GUI Handler");
        proxy.load(event);
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent evt) {
        logger.info("Please Wait: We are saving Harambe with a time machine");
        if (Loader.isModLoaded((String)"MineTweaker3") || Loader.isModLoaded((String)"MineTweaker3".toLowerCase())) {
            MineTweakerIntegration.init();
            logger.info("'Mine Tweaker' integration was loaded");
        }
        proxy.postLoad(evt);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandResetInfoRegistry());
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverClose(FMLServerStoppingEvent event) {
        WirelessManager.removeAll();
        PL2.getNetworkManager().removeAll();
        PL2.getCableManager().removeAll();
        PL2.getDisplayManager().removeAll();
        PL2.getClientManager().removeAll();
        PL2.getServerManager().removeAll();
        PL2.getComparatorRegistry().removeAll();
    }

    public static NetworkManager getNetworkManager() {
        return PL2.instance.networkManager;
    }

    public static CableManager getCableManager() {
        return PL2.instance.cableManager;
    }

    public static DisplayManager getDisplayManager() {
        return PL2.instance.displayManager;
    }

    public static ServerInfoManager getServerManager() {
        return PL2.instance.serverManager;
    }

    public static ClientInfoManager getClientManager() {
        return PL2.instance.clientManager;
    }

    public static IInfoManager getInfoManager(boolean isRemote) {
        return !isRemote ? PL2.getServerManager() : PL2.getClientManager();
    }

    public static ComparatorRegistry getComparatorRegistry() {
        return PL2.instance.comparatorRegistry;
    }

    static {
        logger = LogManager.getLogger((String)"practicallogistics2");
        creativeTab = new CreativeTabs("Practical Logistics 2"){

            public Item func_78016_d() {
                return PL2Items.cable;
            }
        };
    }
}

