/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import sonar.core.helpers.ASMLoader;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.asm.EntityInfoProvider;
import sonar.logistics.api.asm.InfoRegistry;
import sonar.logistics.api.asm.LogicInfoType;
import sonar.logistics.api.asm.NodeFilter;
import sonar.logistics.api.asm.TileInfoProvider;
import sonar.logistics.api.filters.INodeFilter;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.handlers.IEntityInfoProvider;
import sonar.logistics.api.info.handlers.ITileInfoProvider;
import sonar.logistics.api.info.register.IInfoRegistry;
import sonar.logistics.info.LogicInfoRegistry;
import sonar.logistics.logic.comparators.ILogicComparator;

public class PL2ASMLoader {
    public static LinkedHashMap<Integer, String> infoNames = Maps.newLinkedHashMap();
    public static LinkedHashMap<String, Integer> infoIds = Maps.newLinkedHashMap();
    public static LinkedHashMap<String, Class<? extends IInfo>> infoClasses = Maps.newLinkedHashMap();
    public static LinkedHashMap<String, Class<? extends INodeFilter>> filterClasses = Maps.newLinkedHashMap();
    public static LinkedHashMap<String, ILogicComparator> comparatorClasses = Maps.newLinkedHashMap();

    private PL2ASMLoader() {
    }

    public static void init(FMLPreInitializationEvent event) {
        ASMDataTable asmDataTable = event.getAsmData();
        PL2ASMLoader.loadInfoTypes(asmDataTable);
        PL2ASMLoader.loadNodeFilters(asmDataTable);
        LogicInfoRegistry.INSTANCE.infoRegistries.addAll(PL2ASMLoader.getInfoRegistries(asmDataTable));
        LogicInfoRegistry.INSTANCE.tileProviders.addAll(PL2ASMLoader.getTileProviders(asmDataTable));
        LogicInfoRegistry.INSTANCE.entityProviders.addAll(PL2ASMLoader.getEntityProviders(asmDataTable));
    }

    public static List<IInfoRegistry> getInfoRegistries(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances((ASMDataTable)asmDataTable, InfoRegistry.class, IInfoRegistry.class, (boolean)true, (boolean)false);
    }

    public static List<ITileInfoProvider> getTileProviders(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances((ASMDataTable)asmDataTable, TileInfoProvider.class, ITileInfoProvider.class, (boolean)true, (boolean)false);
    }

    public static List<IEntityInfoProvider> getEntityProviders(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances((ASMDataTable)asmDataTable, EntityInfoProvider.class, IEntityInfoProvider.class, (boolean)true, (boolean)false);
    }

    public static void loadInfoTypes(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((ASMDataTable)asmDataTable, LogicInfoType.class, IInfo.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            int hashCode = name.hashCode();
            infoNames.put(hashCode, name);
            infoIds.put(name, hashCode);
            infoClasses.put(name, (Class<? extends IInfo>)info.b);
        }
        PL2.logger.info("Loaded: " + infoIds.size() + " Info Types");
    }

    public static void loadNodeFilters(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((ASMDataTable)asmDataTable, NodeFilter.class, INodeFilter.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            filterClasses.put(name, (Class<? extends INodeFilter>)info.b);
        }
        PL2.logger.info("Loaded: " + filterClasses.size() + " Filters");
    }
}

