/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics;

import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import sonar.logistics.PL2;
import sonar.logistics.common.multiparts.nodes.ArrayPart;
import sonar.logistics.managers.LockedDisplayData;
import sonar.logistics.managers.WirelessManager;

public class PL2Events {
    public static final int saveDimension = 0;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            PL2.getNetworkManager().tick();
            PL2.getServerManager().onServerTick();
            WirelessManager.tick();
            PL2.getDisplayManager().tick();
            ArrayPart.entityChanged = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            LockedDisplayData lockedDisplayData = (LockedDisplayData)event.getWorld().getPerWorldStorage().func_75742_a(LockedDisplayData.class, "sonar.logistics.networks.lockedID");
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        MapStorage storage;
        LockedDisplayData data;
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0 && (data = (LockedDisplayData)(storage = event.getWorld().getPerWorldStorage()).func_75742_a(LockedDisplayData.class, "sonar.logistics.networks.lockedID")) == null && !PL2.getDisplayManager().lockedIDs.isEmpty()) {
            storage.func_75745_a("sonar.logistics.networks.lockedID", (WorldSavedData)new LockedDisplayData("sonar.logistics.networks.lockedID"));
        }
    }

    @SubscribeEvent
    public void watchChunk(ChunkWatchEvent.Watch event) {
        PL2.getServerManager().addListener(event.getChunk(), event.getPlayer());
    }

    @SubscribeEvent
    public void unWatchChunk(ChunkWatchEvent.UnWatch event) {
        PL2.getServerManager().removeListener(event.getChunk(), event.getPlayer());
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        ArrayPart.entityChanged = true;
    }
}

