/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.filters;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.client.gui.GuiSonar;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.SyncNBTAbstractList;
import sonar.logistics.api.asm.NodeFilter;
import sonar.logistics.api.filters.BaseFilter;
import sonar.logistics.api.filters.IFluidFilter;
import sonar.logistics.api.tiles.nodes.TransferType;

@NodeFilter(id="fluid", modid="practicallogistics2")
public class FluidFilter
extends BaseFilter
implements IFluidFilter {
    public static final String id = "fluid";
    public SyncNBTAbstractList<StoredFluidStack> list = new SyncNBTAbstractList(StoredFluidStack.class, 1);

    public FluidFilter() {
        this.syncList.addPart(this.list);
    }

    @Override
    public String getNodeID() {
        return id;
    }

    public List<StoredFluidStack> getFluidFilters() {
        return this.list.objs;
    }

    public void addFluid(StoredFluidStack stack) {
        for (StoredFluidStack fluid : this.list.objs) {
            if (!fluid.equalStack(stack.fluid)) continue;
            return;
        }
        this.list.addObject((INBTSyncable)stack);
    }

    public void removeFluid(StoredFluidStack stack) {
        ArrayList toRemove = Lists.newArrayList();
        for (StoredFluidStack fluid : this.list.objs) {
            if (!fluid.equalStack(stack.fluid)) continue;
            toRemove.add(fluid);
        }
        toRemove.forEach(remove -> this.list.removeObject((INBTSyncable)remove));
    }

    @Override
    public boolean canTransferFluid(StoredFluidStack stack) {
        for (StoredFluidStack fluid : this.list.objs) {
            if (!fluid.equalStack(stack.fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TransferType[] getTypes() {
        return new TransferType[]{TransferType.FLUID};
    }

    @Override
    public void renderInfoInList(GuiSonar screen, int yPos) {
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        FontHelper.text((String)"Fluid Filter", (int)16, (int)((int)((double)((yPos + 2) * 1) / 0.75)), (int)Color.white.getRGB());
        FontHelper.text((String)("Type: " + this.getTransferMode().name()), (int)88, (int)((int)((double)((yPos + 2) * 1) / 0.75)), (int)Color.white.getRGB());
        FontHelper.text((String)("List Type: " + this.getListType().name()), (int)200, (int)((int)((double)((yPos + 2) * 1) / 0.75)), (int)Color.white.getRGB());
        GlStateManager.func_179139_a((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
        int yOffset = 0;
        for (int i = 0; i < Math.min(12, this.list.objs.size()); ++i) {
            if (i == 12) {
                ++yOffset;
            }
            StoredFluidStack item = (StoredFluidStack)this.list.objs.get(i);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(item.fluid.getFluid().getStill().toString());
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            screen.func_175175_a(13 + i * 18, -2 + yPos + yOffset * 18, sprite, 16, 16);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)-12.0f, (float)0.0f);
    }

    @Override
    public boolean isValidFilter() {
        return !this.list.getObjects().isEmpty();
    }
}

