/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.filters;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.client.gui.GuiSonar;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.ItemStackHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstractList;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.NodeFilter;
import sonar.logistics.api.filters.BaseFilter;
import sonar.logistics.api.filters.IItemFilter;
import sonar.logistics.api.tiles.nodes.TransferType;

@NodeFilter(id="item", modid="practicallogistics2")
public class ItemFilter
extends BaseFilter
implements IItemFilter {
    public static final String id = "item";
    public SyncNBTAbstractList<StoredItemStack> list = new SyncNBTAbstractList(StoredItemStack.class, 1);
    public SyncTagType.BOOLEAN matchNBT = new SyncTagType.BOOLEAN(2);
    public SyncTagType.BOOLEAN ignoreDamage = new SyncTagType.BOOLEAN(3);
    public SyncTagType.BOOLEAN matchOreDict = new SyncTagType.BOOLEAN(4);
    public SyncTagType.BOOLEAN matchModid = new SyncTagType.BOOLEAN(5);

    public ItemFilter() {
        this.syncList.addParts(new IDirtyPart[]{this.list, this.matchNBT, this.ignoreDamage, this.matchOreDict, this.matchModid});
    }

    @Override
    public String getNodeID() {
        return id;
    }

    public List<StoredItemStack> getItemFilters() {
        return this.list.objs;
    }

    public void addItem(StoredItemStack stack) {
        for (StoredItemStack item : this.list.objs) {
            if (!item.equalStack(stack.item)) continue;
            return;
        }
        this.list.addObject((INBTSyncable)stack);
    }

    public void removeItem(StoredItemStack stack) {
        ArrayList toRemove = Lists.newArrayList();
        for (StoredItemStack item : this.list.objs) {
            if (!item.equalStack(stack.item)) continue;
            toRemove.add(item);
        }
        toRemove.forEach(remove -> this.list.removeObject((INBTSyncable)remove));
    }

    @Override
    public boolean canTransferItem(StoredItemStack stack) {
        for (StoredItemStack item : this.list.objs) {
            ItemStack item1 = item.item;
            ItemStack item2 = stack.item;
            if (item1.func_77973_b() != item2.func_77973_b() && (!((Boolean)this.matchModid.getObject()).booleanValue() || !ItemStackHelper.matchingModid((ItemStack)item1, (ItemStack)item2)) && (!((Boolean)this.matchOreDict.getObject()).booleanValue() || !ItemStackHelper.matchingOreDictID((ItemStack)item1, (ItemStack)item2)) || !((Boolean)this.ignoreDamage.getObject()).booleanValue() && item1.func_77952_i() != item2.func_77952_i() || ((Boolean)this.matchNBT.getObject()).booleanValue() && !ItemStack.func_77970_a((ItemStack)item1, (ItemStack)item2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TransferType[] getTypes() {
        return new TransferType[]{TransferType.ITEMS};
    }

    @Override
    public void renderInfoInList(GuiSonar screen, int yPos) {
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        FontHelper.text((String)"Item Filter", (int)16, (int)((int)((double)((yPos + 2) * 1) / 0.75)), (int)Color.white.getRGB());
        FontHelper.text((String)("Type: " + this.getTransferMode().name()), (int)88, (int)((int)((double)((yPos + 2) * 1) / 0.75)), (int)Color.white.getRGB());
        FontHelper.text((String)("List Type: " + this.getListType().name()), (int)200, (int)((int)((double)((yPos + 2) * 1) / 0.75)), (int)Color.white.getRGB());
        GlStateManager.func_179139_a((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
        int yOffset = 0;
        for (int i = 0; i < Math.min(12, this.list.objs.size()); ++i) {
            if (i == 12) {
                ++yOffset;
            }
            StoredItemStack item = (StoredItemStack)this.list.objs.get(i);
            RenderHelper.renderItem((GuiSonar)screen, (int)(13 + i * 18), (int)(-2 + yPos), (ItemStack)item.item);
            RenderHelper.renderStoredItemStackOverlay((ItemStack)item.item, (long)0L, (int)(13 + i * 18), (int)(-2 + yPos + yOffset * 18), null, (boolean)true);
            RenderHelper.restoreBlendState();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)-12.0f, (float)0.0f);
    }

    @Override
    public boolean isValidFilter() {
        return !this.list.getObjects().isEmpty();
    }
}

