/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.info;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;

public class InfoUUID
implements INBTSyncable {
    public int identity;
    public int channelID;

    public InfoUUID() {
    }

    public InfoUUID(int identity, int channelID) {
        this.identity = identity;
        this.channelID = channelID;
    }

    public int getIdentity() {
        return this.identity;
    }

    public int getChannelID() {
        return this.channelID;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof InfoUUID) {
            return this.identity == ((InfoUUID)obj).identity && this.channelID == ((InfoUUID)obj).channelID;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.identity, this.channelID});
    }

    public boolean valid() {
        return this.identity != -1 || this.channelID != -1;
    }

    public static InfoUUID getUUID(ByteBuf buf) {
        return new InfoUUID(buf.readInt(), buf.readInt());
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.identity);
        buf.writeInt(this.channelID);
    }

    public String toString() {
        return this.identity + ":" + this.channelID;
    }

    public static InfoUUID fromString(String string) {
        String[] ids = string.split(":");
        return new InfoUUID(Integer.valueOf(ids[0]), Integer.valueOf(ids[1]));
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.identity = nbt.func_74762_e("hash");
        this.channelID = nbt.func_74762_e("pos");
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a("hash", this.identity);
        nbt.func_74768_a("pos", this.channelID);
        return nbt;
    }
}

