/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.info.render;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncPart;
import sonar.core.network.sync.SyncTagTypeList;
import sonar.core.network.sync.SyncableList;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.render.RenderInfoProperties;
import sonar.logistics.api.tiles.displays.DisplayConstants;
import sonar.logistics.client.LogisticsColours;

public class DisplayInfo
extends SyncPart
implements IDisplayInfo,
ISyncableListener {
    public RenderInfoProperties renderInfo;
    public IInfo cachedInfo = null;
    public SyncTagTypeList<String> formatList = new SyncTagTypeList(8, 0);
    public SyncNBTAbstract<InfoUUID> uuid = new SyncNBTAbstract(InfoUUID.class, 1);
    public SyncNBTAbstract<CustomColour> textColour = new SyncNBTAbstract(CustomColour.class, 2);
    public SyncNBTAbstract<CustomColour> backgroundColour = new SyncNBTAbstract(CustomColour.class, 3);
    public InfoContainer container;
    public boolean isList = false;
    public SyncableList syncParts = new SyncableList((ISyncableListener)this);

    public DisplayInfo(InfoContainer container, int id) {
        super(id);
        this.textColour.setObject((INBTSyncable)LogisticsColours.white_text);
        this.backgroundColour.setObject((INBTSyncable)LogisticsColours.grey_base);
        this.syncParts.addParts(new IDirtyPart[]{this.formatList, this.uuid, this.textColour, this.backgroundColour});
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.container = container;
    }

    public RenderInfoProperties setRenderInfoProperties(RenderInfoProperties renderInfo, int pos) {
        this.renderInfo = renderInfo;
        if (this.cachedInfo != null) {
            this.cachedInfo.renderSizeChanged(this.container, this, renderInfo.scaling[0], renderInfo.scaling[1], renderInfo.scaling[2], pos);
        }
        return renderInfo;
    }

    @Override
    public void setUUID(InfoUUID infoUUID) {
        this.uuid.setObject((INBTSyncable)infoUUID);
    }

    @Override
    public IInfo getSidedCachedInfo(boolean isClient) {
        InfoUUID id = this.getInfoUUID();
        if (id == null) {
            return null;
        }
        if (this.cachedInfo == null) {
            this.cachedInfo = PL2.getInfoManager(isClient).getInfoList().get(id);
            this.cachedInfo = this.cachedInfo != null ? this.cachedInfo.copy() : null;
        }
        return this.cachedInfo;
    }

    public void setCachedInfo(IInfo info) {
        this.cachedInfo = info.copy();
    }

    @Override
    public CustomColour getTextColour() {
        return (CustomColour)this.textColour.getObject();
    }

    @Override
    public CustomColour getBackgroundColour() {
        return (CustomColour)this.backgroundColour.getObject();
    }

    @Override
    public InfoUUID getInfoUUID() {
        return (InfoUUID)this.uuid.getObject();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = nbt.func_74775_l(this.getTagName());
        if (!tag.func_82582_d()) {
            NBTHelper.readSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)this.syncParts);
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = NBTHelper.writeSyncParts((NBTTagCompound)new NBTTagCompound(), (NBTHelper.SyncType)type, (SyncableList)this.syncParts, (type == NBTHelper.SyncType.SYNC_OVERRIDE ? 1 : 0) != 0);
        if (!tag.func_82582_d()) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)tag);
        }
        return nbt;
    }

    @Override
    public RenderInfoProperties getRenderProperties() {
        return this.renderInfo;
    }

    @Override
    public void setFormatStrings(ArrayList<String> strings) {
        this.formatList.setObjects(strings);
    }

    @Override
    public ArrayList<String> getUnformattedStrings() {
        return this.formatList.getObjects();
    }

    @Override
    public ArrayList<String> getFormattedStrings() {
        ArrayList format = Lists.newArrayList();
        boolean empty = true;
        for (String string : this.formatList.getObjects()) {
            if (string.isEmpty()) continue;
            empty = false;
            format.add(DisplayConstants.formatText(string, this));
        }
        if (empty) {
            IInfo info = this.getSidedCachedInfo(true);
            if (info == null) {
                info = this.cachedInfo;
            }
            if (info != null && info instanceof INameableInfo) {
                INameableInfo cachedInfo = (INameableInfo)info;
                if (!cachedInfo.getClientIdentifier().isEmpty()) {
                    format.add(cachedInfo.getClientIdentifier());
                }
                format.add(cachedInfo.getClientObject());
            }
        }
        return format;
    }

    public void markChanged(IDirtyPart part) {
        this.syncParts.markSyncPartChanged(part);
        this.container.markChanged((IDirtyPart)this);
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }
}

