/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.info.render;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncableList;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IAdvancedClickableInfo;
import sonar.logistics.api.info.IBasicClickableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.info.render.DisplayInfo;
import sonar.logistics.api.info.render.IDisplayInfo;
import sonar.logistics.api.info.render.IInfoContainer;
import sonar.logistics.api.render.RenderInfoProperties;
import sonar.logistics.api.tiles.displays.DisplayInteractionEvent;
import sonar.logistics.api.tiles.displays.DisplayLayout;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.InfoError;
import sonar.logistics.info.types.LogicInfoList;
import sonar.logistics.network.PacketClickEventClient;

public class InfoContainer
extends DirtyPart
implements IInfoContainer,
ISyncPart {
    public final ArrayList<DisplayInfo> storedInfo = Lists.newArrayList();
    public final IDisplay display;
    public SyncableList syncParts = new SyncableList((ISyncableListener)this);
    public long lastClickTime;
    public UUID lastClickUUID;
    public boolean hasChanged = true;

    public InfoContainer(IDisplay display) {
        this.display = display;
        this.setListener(display);
        for (int i = 0; i < display.maxInfo(); ++i) {
            DisplayInfo syncPart = new DisplayInfo(this, i);
            this.storedInfo.add(syncPart);
        }
        this.syncParts.addParts(this.storedInfo);
        this.resetRenderProperties();
    }

    public void resetRenderProperties() {
        for (int i = 0; i < this.storedInfo.size(); ++i) {
            DisplayInfo info = this.storedInfo.get(i);
            double[] scaling = InfoHelper.getScaling(this.display, this.display.getLayout(), i);
            double[] translation = InfoHelper.getTranslation(this.display, this.display.getLayout(), i);
            info.setRenderInfoProperties(new RenderInfoProperties(this, i, scaling, translation), i);
        }
    }

    public static ResourceLocation getColour(int infoPos) {
        switch (infoPos) {
            case 0: {
                return LogisticsColours.colourTex1;
            }
            case 1: {
                return LogisticsColours.colourTex2;
            }
            case 2: {
                return LogisticsColours.colourTex3;
            }
            case 3: {
                return LogisticsColours.colourTex4;
            }
        }
        return LogisticsColours.colourTex1;
    }

    @Override
    public boolean isDisplayingUUID(InfoUUID id) {
        return this.getDisplayMonitoringUUID(id) != null;
    }

    @Override
    public InfoUUID getInfoUUID(int pos) {
        return this.storedInfo.get(pos).getInfoUUID();
    }

    @Override
    public void setUUID(InfoUUID id, int pos) {
        this.storedInfo.get(pos).setUUID(id);
        this.markChanged();
    }

    @Override
    public void renderContainer() {
        if (this.display.getDisplayType() == DisplayType.LARGE) {
            GL11.glTranslated((double)0.0, (double)-0.25, (double)0.0);
        }
        if (this.display.getDisplayType() == DisplayType.HOLOGRAPHIC) {
            GL11.glTranslated((double)0.0625, (double)-0.4375, (double)0.0);
        }
        DisplayLayout layout = this.display.getLayout();
        DisplayType type = this.display.getDisplayType();
        for (int pos = 0; pos < layout.maxInfo; ++pos) {
            IDisplayInfo info = this.storedInfo.get(pos);
            GL11.glPushMatrix();
            double[] translation = info.getRenderProperties().translation;
            double[] scaling = info.getRenderProperties().scaling;
            GL11.glTranslated((double)translation[0], (double)translation[1], (double)translation[2]);
            if (info.getSidedCachedInfo(true) == null && !info.getUnformattedStrings().isEmpty()) {
                InfoRenderer.renderNormalInfo(type, scaling[0], scaling[1], scaling[2], info.getFormattedStrings());
            } else {
                InfoError toDisplay = info.getSidedCachedInfo(true) == null ? InfoError.noData : info.getSidedCachedInfo(true);
                toDisplay.renderInfo(this, info, scaling[0], scaling[1], scaling[2], pos);
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public boolean onClicked(AbstractDisplayPart part, BlockInteractionType type, World world, EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        boolean doubleClick = false;
        if (world.func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID)) {
            doubleClick = true;
        }
        this.lastClickTime = world.func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        for (int i = 0; i < this.display.maxInfo(); ++i) {
            Object clickable;
            IDisplayInfo info = this.storedInfo.get(i);
            IInfo cachedInfo = info.getSidedCachedInfo(world.field_72995_K);
            if (cachedInfo instanceof IAdvancedClickableInfo) {
                if (world.field_72995_K) continue;
                clickable = (IAdvancedClickableInfo)((Object)cachedInfo);
                int hashCode = UUID.randomUUID().hashCode();
                DisplayInteractionEvent event = new DisplayInteractionEvent(hashCode, cachedInfo, i, player, type, doubleClick, hand, hit);
                PL2.getServerManager().clickEvents.put(hashCode, event);
                PL2.network.sendTo((IMessage)new PacketClickEventClient(part.getUUID(), part.getPos(), event), (EntityPlayerMP)player);
                continue;
            }
            if (!(cachedInfo instanceof IBasicClickableInfo)) continue;
            clickable = (IBasicClickableInfo)((Object)cachedInfo);
            return clickable.onStandardClick(type, doubleClick, info, player, hand, stack, hit, this);
        }
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = nbt.func_74775_l(this.getTagName());
        if (!tag.func_82582_d()) {
            NBTHelper.readSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)this.syncParts);
            this.resetRenderProperties();
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = NBTHelper.writeSyncParts((NBTTagCompound)new NBTTagCompound(), (NBTHelper.SyncType)type, (SyncableList)this.syncParts, (type == NBTHelper.SyncType.SYNC_OVERRIDE ? 1 : 0) != 0);
        if (!tag.func_82582_d()) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)tag);
        }
        return nbt;
    }

    @Override
    public int getMaxCapacity() {
        return Math.min(this.display.maxInfo(), this.display.getLayout().maxInfo);
    }

    @Override
    public IDisplay getDisplay() {
        return this.display;
    }

    @Override
    public DisplayInfo getDisplayInfo(int pos) {
        return this.storedInfo.get(pos);
    }

    public InfoContainer cloneFromContainer(IInfoContainer container) {
        this.readData(container.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE), NBTHelper.SyncType.SAVE);
        return this;
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    public boolean canSync(NBTHelper.SyncType sync) {
        return NBTHelper.SyncType.isGivenType((NBTHelper.SyncType)sync, (NBTHelper.SyncType[])new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE});
    }

    public String getTagName() {
        return "container";
    }

    public void markChanged(IDirtyPart part) {
        this.syncParts.markSyncPartChanged(part);
        this.listener.markChanged((IDirtyPart)this);
    }

    @Override
    public void forEachValidUUID(Consumer<InfoUUID> action) {
        for (int i = 0; i < this.display.container().getMaxCapacity(); ++i) {
            InfoUUID uuid = this.display.container().getInfoUUID(i);
            if (uuid == null) continue;
            action.accept(uuid);
        }
    }

    @Nullable
    public DisplayInfo getDisplayMonitoringUUID(InfoUUID uuid) {
        for (int i = 0; i < this.display.getLayout().maxInfo; ++i) {
            DisplayInfo info = this.getDisplayInfo(i);
            if (info == null || !uuid.equals(info.getInfoUUID())) continue;
            return info;
        }
        return null;
    }

    @Override
    public void onMonitoredListChanged(InfoUUID uuid, MonitoredList list) {
        DisplayInfo displayInfo = this.getDisplayMonitoringUUID(uuid);
        if (displayInfo != null && displayInfo.cachedInfo instanceof LogicInfoList) {
            ((LogicInfoList)displayInfo.cachedInfo).setCachedList((MonitoredList)list.cloneInfo(), uuid);
        }
    }

    @Override
    public void onInfoChanged(InfoUUID uuid, IInfo info) {
        DisplayInfo displayInfo = this.getDisplayMonitoringUUID(uuid);
        if (info != null) {
            displayInfo.setCachedInfo(info);
        }
    }
}

