/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.networks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ISonarListener;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.networks.INetworkChannels;
import sonar.logistics.api.networks.INetworkListener;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.utils.CacheType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.connections.CacheHandler;
import sonar.logistics.connections.NetworkUpdate;

public interface ILogisticsNetwork
extends ISonarListener,
ISonarListenable<ILogisticsNetwork> {
    public static final int CONNECTED_NETWORK = 0;
    public static final int WATCHING_NETWORK = 1;

    public int getNetworkID();

    public void onNetworkCreated();

    public void onNetworkTick();

    public void onNetworkRemoved();

    public void onCablesChanged();

    public void onCacheChanged(CacheHandler ... var1);

    public void markUpdate(NetworkUpdate ... var1);

    public boolean validateTile(INetworkListener var1);

    public void onConnectionChanged(INetworkListener var1);

    public void addConnection(INetworkListener var1);

    public void removeConnection(INetworkListener var1);

    public void addConnections();

    public void removeConnections();

    public void addLocalInfoProvider(IInfoProvider var1);

    public void removeLocalInfoProvider(IInfoProvider var1);

    public void sendConnectionsPacket(EntityPlayer var1);

    public List<NodeConnection> getConnections(CacheType var1);

    public MonitoredList<IInfo> createConnectionsList(CacheType var1);

    public <T> List<T> getCachedTiles(CacheHandler<T> var1, CacheType var2);

    @Nullable
    public <T extends INetworkChannels> T getNetworkChannels(Class<T> var1);

    public <T extends INetworkChannels> T getOrCreateNetworkChannels(Class<T> var1);

    public List<IInfoProvider> getLocalInfoProviders();

    public IInfoProvider getLocalInfoProvider();
}

