/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.register;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public enum RegistryType {
    WORLD(World.class, 0),
    TILE(TileEntity.class, 5),
    BLOCK(Block.class, 3),
    ENTITY(Entity.class, 6),
    ITEM(Item.class, 7),
    STATE(IBlockState.class, 4),
    POS(BlockPos.class, 1),
    FACE(EnumFacing.class, 2),
    ITEMSTACK(ItemStack.class, 8),
    CAPABILITY(Capability.class, 9),
    NONE(null, 9);

    Class classType;
    public int sortOrder;

    private RegistryType(Class classType, int sortOrder) {
        this.classType = classType;
        this.sortOrder = sortOrder;
    }

    public boolean isAssignable(Class<?> toCheck) {
        return this.classType != null && this.classType.isAssignableFrom(toCheck);
    }

    public static RegistryType getRegistryType(Class<?> toCheck) {
        for (RegistryType type : RegistryType.values()) {
            if (!type.isAssignable(toCheck)) continue;
            return type;
        }
        return NONE;
    }

    public static List<Class<?>> buildList() {
        ArrayList classes = Lists.newArrayList();
        for (RegistryType type : RegistryType.values()) {
            if (type.classType == null) continue;
            classes.add(type.classType);
        }
        return classes;
    }
}

