/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.states;

import java.util.List;
import sonar.core.translate.Localisation;
import sonar.logistics.api.states.IState;

public enum TileMessage implements IState
{
    NO_NETWORK(false),
    NO_READER_SELECTED(true),
    NO_EMITTERS_CONNECTED(true),
    EMITTERS_OFFLINE(true),
    NO_DATA_SELECTED(true),
    NO_STACK_SELECTED(true),
    NO_FLUID_SELECTED(true),
    NO_STATEMENTS(true);

    public boolean canOpen;
    public Localisation message;

    private TileMessage(boolean canOpen) {
        this.canOpen = canOpen;
        this.message = new Localisation("pl.states." + this.name().toLowerCase());
    }

    @Override
    public boolean canOpenTile() {
        return this.canOpen;
    }

    @Override
    public String getStateMessage() {
        return this.message.t();
    }

    @Override
    public int getStateID() {
        return this.ordinal();
    }

    public static List<Localisation> getLocalisations(List<Localisation> current) {
        for (TileMessage message : TileMessage.values()) {
            current.add(message.message);
        }
        return current;
    }
}

