/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.tiles.displays;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncableList;
import sonar.core.utils.IUUIDIdentity;
import sonar.logistics.PL2;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.info.render.IInfoContainer;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.EmptyLogisticsNetwork;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.IConnectable;
import sonar.logistics.api.tiles.cable.ConnectableType;
import sonar.logistics.api.tiles.cable.NetworkConnectionType;
import sonar.logistics.api.tiles.displays.DisplayLayout;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.displays.ILargeDisplay;
import sonar.logistics.api.tiles.displays.IScaleableDisplay;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.helpers.LogisticsHelper;
import sonar.logistics.network.PacketConnectedDisplayScreen;

public class ConnectedDisplay
implements IDisplay,
IConnectable,
INBTSyncable,
IScaleableDisplay,
ISyncPart {
    public ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, ListenerType.ALL.size());
    private int registryID = -1;
    public ILargeDisplay topLeftScreen = null;
    public SyncableList syncParts = new SyncableList((ISyncableListener)this);
    public SyncEnum<EnumFacing> face = new SyncEnum((Enum[])EnumFacing.field_82609_l, 0);
    public SyncEnum<DisplayLayout> layout = new SyncEnum((Enum[])DisplayLayout.values(), 1);
    public SyncTagType.INT width = new SyncTagType.INT(2);
    public SyncTagType.INT height = new SyncTagType.INT(3);
    public SyncTagType.BOOLEAN canBeRendered = new SyncTagType.BOOLEAN(4);
    public InfoContainer container = new InfoContainer(this);
    public SyncCoords topLeftCoords = new SyncCoords(5);
    public SyncTagType.BOOLEAN isLocked = new SyncTagType.BOOLEAN(6);
    public boolean hasChanged = true;
    public boolean sendViewers;
    public List<ILargeDisplay> displays = Lists.newArrayList();

    public ConnectedDisplay(ILargeDisplay display) {
        this.syncParts.addParts(new IDirtyPart[]{this.face, this.layout, this.width, this.height, this.canBeRendered, this.topLeftCoords, this.container, this.isLocked});
        this.registryID = display.getRegistryID();
        this.face.setObject((Enum)display.getCableFace());
        this.hasChanged = true;
    }

    public ConnectedDisplay(int registryID) {
        this.syncParts.addParts(new IDirtyPart[]{this.face, this.layout, this.width, this.height, this.canBeRendered, this.topLeftCoords, this.container, this.isLocked});
        this.registryID = registryID;
        this.hasChanged = true;
    }

    public void lock() {
        this.isLocked.setObject((Object)true);
        PL2.getDisplayManager().lockedIDs.add(this.registryID);
    }

    public void unlock() {
        this.isLocked.setObject((Object)false);
        PL2.getDisplayManager().lockedIDs.remove(this.registryID);
    }

    public void update(int registryID) {
        if (this.sendViewers) {
            this.sendViewers();
        }
        if (this.hasChanged || this.registryID != registryID) {
            this.registryID = registryID;
            this.displays = PL2.getDisplayManager().getConnections(registryID);
            if (!this.displays.isEmpty() && !this.displays.get((int)0).getCoords().getWorld().field_72995_K) {
                this.setDisplayScaling(this.displays.get(0), this.displays);
            }
            this.hasChanged = false;
            this.sendViewers = true;
        }
    }

    public void sendViewers() {
        List listeners = this.getListenerList().getListeners(new Enum[]{ListenerType.INFO, ListenerType.FULL_INFO});
        if (!listeners.isEmpty()) {
            listeners.forEach(listener -> PL2.network.sendTo((IMessage)new PacketConnectedDisplayScreen(this, this.registryID), listener.player));
            this.sendViewers = false;
        } else {
            this.sendViewers = true;
        }
    }

    public void setDisplayScaling(ILargeDisplay primary, List<ILargeDisplay> displays) {
        displays.forEach(display -> display.setConnectedDisplay(this));
        BlockCoords primaryCoords = primary.getCoords();
        int minX = primaryCoords.getX();
        int maxX = primaryCoords.getX();
        int minY = primaryCoords.getY();
        int maxY = primaryCoords.getY();
        int minZ = primaryCoords.getZ();
        int maxZ = primaryCoords.getZ();
        EnumFacing meta = primary.getCableFace();
        boolean north = meta == EnumFacing.NORTH;
        for (ILargeDisplay display2 : displays) {
            BlockCoords coords = display2.getCoords();
            if (coords.getX() > maxX) {
                maxX = coords.getX();
            } else if (coords.getX() < minX) {
                minX = coords.getX();
            }
            if (coords.getY() > maxY) {
                maxY = coords.getY();
            } else if (coords.getY() < minY) {
                minY = coords.getY();
            }
            if (coords.getZ() > maxZ) {
                maxZ = coords.getZ();
                continue;
            }
            if (coords.getZ() >= minZ) continue;
            minZ = coords.getZ();
        }
        block0 : switch (meta.func_176740_k()) {
            case X: {
                this.width.setObject((Object)(maxZ - minZ));
                this.height.setObject((Object)(maxY - minY));
                break;
            }
            case Y: {
                this.width.setObject((Object)(maxX - minX));
                this.height.setObject((Object)(maxZ - minZ));
                if (meta == EnumFacing.UP) {
                    switch (primary.getRotation()) {
                        case DOWN: {
                            break block0;
                        }
                        case EAST: {
                            int newX = maxX;
                            maxX = minX;
                            minX = newX;
                            break block0;
                        }
                        case NORTH: {
                            break block0;
                        }
                        case SOUTH: {
                            int newX = maxX;
                            maxX = minX;
                            minX = newX;
                            int newZ = maxZ;
                            maxZ = minZ;
                            minZ = newZ;
                            break block0;
                        }
                        case UP: {
                            break block0;
                        }
                        case WEST: {
                            int newZ = maxZ;
                            maxZ = minZ;
                            minZ = newZ;
                            break block0;
                        }
                    }
                    break;
                }
                if (meta != EnumFacing.DOWN) break;
                switch (primary.getRotation()) {
                    case DOWN: {
                        break block0;
                    }
                    case EAST: {
                        int newX = maxX;
                        maxX = minX;
                        minX = newX;
                        int newZ = maxZ;
                        maxZ = minZ;
                        minZ = newZ;
                        break block0;
                    }
                    case NORTH: {
                        int newX = maxX;
                        maxX = minX;
                        minX = newX;
                        break block0;
                    }
                    case SOUTH: {
                        int newZ = maxZ;
                        maxZ = minZ;
                        minZ = newZ;
                        break block0;
                    }
                    case UP: {
                        break block0;
                    }
                    case WEST: {
                        break block0;
                    }
                }
                break;
            }
            case Z: {
                this.width.setObject((Object)(maxX - minX));
                this.height.setObject((Object)(maxY - minY));
                break;
            }
        }
        for (int x = Math.min(minX, maxX); x <= Math.max(minX, maxX); ++x) {
            for (int y = Math.min(minY, maxY); y <= Math.max(minY, maxY); ++y) {
                for (int z = Math.min(minZ, maxZ); z <= Math.max(minZ, maxZ); ++z) {
                    BlockCoords coords = new BlockCoords(x, y, z);
                    IDisplay display3 = PL2API.getCableHelper().getDisplayScreen(coords, meta);
                    if (display3 == null || !(display3 instanceof ILargeDisplay)) {
                        this.canBeRendered.setObject((Object)false);
                        return;
                    }
                    EnumFacing.AxisDirection dir = meta.func_176743_c();
                    if (meta.func_176740_k() != EnumFacing.Axis.Z) {
                        dir = dir == EnumFacing.AxisDirection.POSITIVE ? EnumFacing.AxisDirection.NEGATIVE : EnumFacing.AxisDirection.POSITIVE;
                    }
                    boolean isTopLeft = dir == EnumFacing.AxisDirection.POSITIVE && x == minX && y == maxY && z == minZ || dir == EnumFacing.AxisDirection.NEGATIVE && x == maxX && y == maxY && z == maxZ;
                    this.setTopLeftScreen((ILargeDisplay)display3, isTopLeft);
                }
            }
        }
        this.canBeRendered.setObject((Object)true);
    }

    public List<ILogicListenable> getLocalProviders(List<ILogicListenable> monitors) {
        this.displays = PL2.getDisplayManager().getConnections(this.registryID);
        for (ILargeDisplay display : this.displays) {
            if (!(display instanceof AbstractDisplayPart)) continue;
            monitors = LogisticsHelper.getLocalProviders(monitors, (AbstractDisplayPart)((Object)display));
        }
        return monitors;
    }

    public void setHasChanged() {
        this.hasChanged = true;
    }

    public void setTopLeftScreen(ILargeDisplay display, boolean isTopLeft) {
        if (isTopLeft) {
            this.topLeftScreen = display;
            this.topLeftCoords.setCoords(display.getCoords());
            display.setShouldRender(true);
            this.face.setObject((Enum)display.getCableFace());
            if (!display.getCoords().getWorld().field_72995_K) {
                PL2.getServerManager().addDisplay(display);
            }
        } else {
            display.setShouldRender(false);
            if (!display.getCoords().getWorld().field_72995_K) {
                PL2.getServerManager().removeDisplay(display);
            }
        }
    }

    @Override
    public IInfoContainer container() {
        return this.container;
    }

    @Override
    public DisplayLayout getLayout() {
        return (DisplayLayout)this.layout.getObject();
    }

    @Override
    public DisplayType getDisplayType() {
        return DisplayType.LARGE;
    }

    @Override
    public int maxInfo() {
        return this.topLeftScreen != null ? this.topLeftScreen.maxInfo() : 4;
    }

    @Override
    public EnumFacing getCableFace() {
        return this.topLeftScreen != null ? this.topLeftScreen.getCableFace() : EnumFacing.NORTH;
    }

    @Override
    public NetworkConnectionType canConnect(EnumFacing dir) {
        return NetworkConnectionType.NETWORK;
    }

    public BlockCoords getCoords() {
        return this.topLeftScreen != null ? this.topLeftScreen.getCoords() : null;
    }

    @Override
    public int getNetworkID() {
        return this.topLeftScreen != null ? this.topLeftScreen.getNetworkID() : -1;
    }

    @Override
    public ConnectableType getConnectableType() {
        return ConnectableType.CONNECTABLE;
    }

    @Override
    public void addConnection() {
    }

    @Override
    public void removeConnection() {
    }

    @Override
    public int getRegistryID() {
        return this.registryID;
    }

    @Override
    public void setRegistryID(int id) {
        this.registryID = id;
        this.hasChanged = true;
    }

    @Override
    public boolean canConnectOnSide(int connectingID, EnumFacing dir, boolean internal) {
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            NBTTagCompound tag = nbt.func_74775_l(this.getTagName());
            NBTHelper.readSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)this.syncParts);
            this.container.resetRenderProperties();
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTHelper.writeSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)this.syncParts, (boolean)true);
        if (!tag.func_82582_d()) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)tag);
        }
        return nbt;
    }

    public ILargeDisplay getTopLeftScreen() {
        IDisplay display;
        if (this.topLeftCoords.getCoords() != null && (display = PL2API.getCableHelper().getDisplayScreen(this.topLeftCoords.getCoords(), (EnumFacing)this.face.getObject())) instanceof ILargeDisplay) {
            this.topLeftScreen = (ILargeDisplay)display;
        }
        return this.topLeftScreen;
    }

    @Override
    public double[] getScaling() {
        double max = Math.min((double)((Integer)this.height.getObject()).intValue() + 1.3, (double)((Integer)this.width.getObject() + 1));
        return new double[]{this.getDisplayType().width + (double)((Integer)this.width.getObject()).intValue(), this.getDisplayType().height + (double)((Integer)this.height.getObject()).intValue(), max / 100.0};
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
        this.container.resetRenderProperties();
    }

    public boolean canSync(NBTHelper.SyncType sync) {
        return NBTHelper.SyncType.isGivenType((NBTHelper.SyncType)sync, (NBTHelper.SyncType[])new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE});
    }

    public String getTagName() {
        return "connected";
    }

    public ISyncableListener getListener() {
        return this.getTopLeftScreen();
    }

    public IDirtyPart setListener(ISyncableListener listener) {
        if (listener instanceof ILargeDisplay && listener != this.topLeftScreen) {
            this.setTopLeftScreen((ILargeDisplay)listener, true);
        }
        return this;
    }

    public void markChanged(IDirtyPart part) {
        this.syncParts.markSyncPartChanged(part);
        if (this.getTopLeftScreen() != null) {
            this.getTopLeftScreen().markChanged((IDirtyPart)this);
        }
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
    }

    public void onListenerRemoved(ListenerTally<PlayerListener> tally) {
    }

    public void onSubListenableAdded(ISonarListenable<PlayerListener> listen) {
    }

    public void onSubListenableRemoved(ISonarListenable<PlayerListener> listen) {
    }

    @Override
    public int getIdentity() {
        return -1;
    }

    @Override
    public EnumFacing getRotation() {
        return this.getTopLeftScreen() == null ? EnumFacing.NORTH : this.getTopLeftScreen().getRotation();
    }

    @Override
    public ILogisticsNetwork getNetwork() {
        return this.getTopLeftScreen() == null ? EmptyLogisticsNetwork.INSTANCE : this.getTopLeftScreen().getNetwork();
    }

    public boolean isValid() {
        return true;
    }

    @Override
    public void onNetworkConnect(ILogisticsNetwork network) {
    }

    @Override
    public void onNetworkDisconnect(ILogisticsNetwork network) {
    }

    @Override
    public UUID getUUID() {
        return this.getTopLeftScreen() == null ? IUUIDIdentity.INVALID_UUID : this.getTopLeftScreen().getUUID();
    }

    @Override
    public TileMessage[] getValidMessages() {
        return new TileMessage[0];
    }
}

