/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.tiles.displays;

import io.netty.buffer.ByteBuf;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import sonar.core.api.utils.BlockInteractionType;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.common.multiparts.AbstractDisplayPart;

public class DisplayInteractionEvent {
    public int hashCode;
    public IInfo currentInfo;
    public int infoPos;
    public EntityPlayer player;
    public BlockInteractionType type;
    public boolean doubleClick;
    public EnumHand hand;
    public PartMOP hit;

    public DisplayInteractionEvent() {
    }

    public DisplayInteractionEvent(int hashCode, IInfo currentInfo, int infoPos, EntityPlayer player, BlockInteractionType type, boolean doubleClick, EnumHand hand, PartMOP hit) {
        this.hashCode = hashCode;
        this.currentInfo = currentInfo;
        this.infoPos = infoPos;
        this.player = player;
        this.type = type;
        this.doubleClick = doubleClick;
        this.hand = hand;
        this.hit = hit;
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.hashCode);
        buf.writeInt(this.infoPos);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.hand.ordinal());
        buf.writeBoolean(this.doubleClick);
    }

    public static DisplayInteractionEvent readFromBuf(ByteBuf buf, EntityPlayer player, AbstractDisplayPart part) {
        DisplayInteractionEvent event = new DisplayInteractionEvent();
        event.hashCode = buf.readInt();
        event.infoPos = buf.readInt();
        event.player = player;
        event.type = BlockInteractionType.values()[buf.readInt()];
        event.hand = EnumHand.values()[buf.readInt()];
        event.doubleClick = buf.readBoolean();
        event.hit = part.getPartHit(player);
        event.currentInfo = part.container().getDisplayInfo(event.infoPos).getSidedCachedInfo(player.func_130014_f_().field_72995_K);
        return event;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DisplayInteractionEvent) {
            return ((DisplayInteractionEvent)obj).hashCode == this.hashCode;
        }
        return false;
    }
}

